<?php
session_start();

if (!isset($_SESSION['idusuario'])) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['data' => [], 'error' => 'Sesin no vlida'], JSON_UNESCAPED_UNICODE);
    exit;
}

$idusuario = (int)($_SESSION['idusuario'] ?? 0);
$usuario   = $_SESSION['usuario']  ?? '';
$sucursal  = $_SESSION['sucursal'] ?? '';

require_once 'conex.php';

// Asegurar UTF-8 real y (opcional) zona horaria de sesin SQL
if (isset($conn) && $conn instanceof mysqli) {
    mysqli_set_charset($conn, 'utf8mb4');
    @mysqli_query($conn, "SET time_zone = '-05:00'"); // America/Guayaquil
}

header('Content-Type: application/json; charset=utf-8');

// Total numrico
$total = 0.0;

// Consulta: 2 cifras (id_cifras = 1) y estado = 3 (pagado)
$sql = "
SELECT 
    t.idrifa,
    t.codigo,
    l.loteria,
    t.numero,				
    t.fecha AS fechar,
    l.fecha AS fechaj,
    t.valor,
    ts.premio,				
    s.suerte_g,
    suc.sucursal,
    u.usuario
FROM tbr_sorteo AS s
INNER JOIN tbr_ticket AS t 
    ON (
        (t.id_cifras = 1 AND (t.numero) = RIGHT(s.numero_g, 2)) -- 2 cifras
    )
    AND t.fecha = s.fecha_g
INNER JOIN tbr_cifras   AS c   ON c.idcifras   = t.id_cifras
INNER JOIN tbr_loteria  AS l   ON l.idloteria  = t.id_loteria
INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa    
INNER JOIN tbr_usuario  AS u   ON u.idusuario  = t.id_usuario
INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
WHERE t.condicion 	= 1 
  AND t.estado 		= 3
  AND s.activo 		= 1
  AND s.condicion 	= 1
  AND l.id_pais 	= 1
  AND l.id_premio 	= 1
  AND t.id_usuario = $idusuario
  AND ts.id_suerte = s.suerte_g
";

$consulta = mysqli_query($conn, $sql);

if (!$consulta) {
    echo json_encode([
        'data'  => [],
        'error' => 'Error en la consulta: ' . mysqli_error($conn)
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

$data = [];

while ($row = mysqli_fetch_assoc($consulta)) {
    // Nmeros puros
    $valor  = (float)$row['valor'];
    $premio = (float)$row['premio'];

    // Formato de salida (texto)
    $valor_formateado  = number_format($valor, 2, '.', ',');
    $premio_formateado = number_format($premio, 2, '.', ',');

    // Para 2 cifras ?? pad a 2
    $numero_formateado = str_pad((string)$row['numero'], 2, '0', STR_PAD_LEFT);

    // Acumular
    $total += $valor;

    $data[] = [
        'codigo'     => $row['codigo'],
        'loteria'    => $row['loteria'],
        'numero'     => $numero_formateado,
        'fechar'     => $row['fechar'],
        'fechaj'     => $row['fechaj'],
        'valor'      => $valor_formateado,
        'negocio'    => $row['sucursal'],
        'usuario'    => $row['usuario'],
        'porcentaje' => '0.00',
        'pagar'      => $premio_formateado
    ];
}

echo json_encode([
    'data'  => $data,
    // Si tu DataTable no usa 'total', elimina esta lnea:
    'total' => number_format($total, 2, '.', ',')
], JSON_UNESCAPED_UNICODE);
