<?php
session_start();
include("conex.php");

$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);
$usuario = htmlspecialchars($_SESSION['usuario']);
$sucursal = htmlspecialchars($_SESSION['sucursal']);

// Inicializar la variable $total
$total = 0;
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d'); // Cambio de formato correcto
//$time_actual = date("H:i");
$time_actual = (int) str_replace(":", "", date("H:i"));

// Consulta con mysqli (evitar inyecci贸n SQL)
$sql = "SELECT 
            t.idrifa, 
            t.codigo, 
            l.loteria,
            l.hora_inicio,
			l.hora_fin,
            t.numero, 
            t.fecha_impreso as fechar,
            t.hora_impreso,
		    t.fecha as fechaj,  
            t.valor, 
            su.sucursal, 
            u.usuario, 
			u.hora_inicio_a,
			u.hora_fin_a,
            t.condicion
        FROM tbr_ticket AS t
        INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
        INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
        INNER JOIN tbr_sucursal AS su ON su.idsucursal = u.id_sucursal
        WHERE t.id_usuario = '$idusuario' 
          AND t.condicion = 1
          AND l.id_pais = 2
		  AND l.id_premio = 2
          AND t.estado = 2
		  AND id_cifras = 2
          AND t.fecha_impreso = '$fecha_actual'  
        ORDER BY t.idrifa DESC";

$consulta = mysqli_query($conn, $sql);

$tabla = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    //$horai = (int) str_replace(":", "", $row['hora_inicio_a']);
    //$horai = (int) str_replace(":", "", $row['hora_inicio']);
    $horai = (int) str_replace(":", "", substr($row['hora_inicio'], 0, 5));
    //$horaf = (int) str_replace(":", "", $row['hora_fin_a']);
    $horaf = (int) str_replace(":", "", substr($row['hora_fin'], 0, 5));
    $valor = (float)$row['valor'];
	 
	$valor_formateado = number_format($valor, 2, '.', ',');
	$numero_formateado = str_pad($row['numero'], 3, '0', STR_PAD_LEFT);

		// Sumar al total
		$total += $valor;
	if($time_actual >= $horai && $time_actual <= $horaf)
	{
		// Acci贸n eliminar
		$eliminar = '<a href="actionDelete_fila.php?idrifa=' . $row['idrifa'] . '" 
						data-toggle="tooltip" data-placement="top" title="Eliminar" 
						class="btn btn-danger">
						<i class="fa fa-trash" aria-hidden="true"></i>
					 </a>';

		// Construir fila en JSON
		$tabla[] = [
			"codigo"    => $row['codigo'],
			"loteria"   => $row['loteria'],
			"numero"    => $numero_formateado,
			"fechar"    => $row['fechar'].' '.$row['hora_impreso'],
			"fechaj"    => $row['fechaj'],
			"valor"     => $valor_formateado,
			"negocio"   => $row['sucursal'],
			"usuario"   => $row['usuario'],			
			"pagar"     => $valor_formateado,
			"accion"    => $eliminar
		];
	}
	else
	{
		// Construir fila en JSON
		$tabla[] = [
			"codigo"    => $row['codigo'],
			"loteria"   => $row['loteria'],
			"numero"    => $numero_formateado,
			"fechar"    => $row['fechar'].' '.$row['hora_impreso'],
			"fechaj"    => $row['fechaj'],
			"valor"     => $valor_formateado,
			"negocio"   => $row['sucursal'],
			"usuario"   => $row['usuario'],			
			"pagar"     => $valor_formateado,
			"accion"    => ""
		]; 
	}
}

// Enviar JSON limpio
echo json_encode(["data" => $tabla], JSON_UNESCAPED_UNICODE);
?>
