<?php
session_start();
include("conex.php");

$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);
$usuario = htmlspecialchars($_SESSION['usuario']);
$sucursal = htmlspecialchars($_SESSION['sucursal']);

// Inicializar la variable $total
$total = 0;
date_default_timezone_set('America/Guayaquil');

$fecha_actual = date('Y-m-d');
$time_actual  = (int) str_replace(":", "", date("H:i"));
$now_ts       = time(); // timestamp actual (Ecuador)

// Consulta con mysqli (evitar inyección SQL)
$sql = "SELECT 
            t.idrifa, 
            t.codigo, 
            l.loteria, 
            t.numero, 
            t.fecha_impreso as fechar, 
            t.hora_impreso,
            t.fecha as fechaj,  
            t.valor, 
            su.sucursal, 
            u.usuario, 
            u.hora_inicio_a,
            u.hora_fin_a,
            t.condicion
        FROM tbr_ticket AS t
        INNER JOIN tbr_loteria AS l ON l.idloteria = t.id_loteria
        INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
        INNER JOIN tbr_sucursal AS su ON su.idsucursal = u.id_sucursal
        WHERE t.id_usuario = '$idusuario' 
          AND t.condicion = 1
          AND l.id_pais = 1
          AND l.id_premio = 1
          AND t.estado = 2
          AND id_cifras = 1
          AND t.fecha_impreso = '$fecha_actual'  
        ORDER BY t.idrifa DESC";

$consulta = mysqli_query($conn, $sql);

$tabla = [];
while ($row = mysqli_fetch_assoc($consulta)) {

    $horai = (int) str_replace(":", "", (string)$row['hora_inicio_a']);
    $horaf = (int) str_replace(":", "", (string)$row['hora_fin_a']);
    $valor = (float)$row['valor'];  

    $valor_formateado  = number_format($valor, 2, '.', ',');
    $numero_formateado = str_pad((string)$row['numero'], 2, '0', STR_PAD_LEFT);

    // Sumar al total
    $total += $valor;

    // =============================
    // ✅ Regla: 15 minutos desde hora_impreso
    // =============================
    $hora_impreso = trim((string)$row['hora_impreso']);
    $ts_impreso   = 0;

    if ($hora_impreso !== '') {
        // si viene HH:ii => HH:ii:00
        if (preg_match('/^\d{2}:\d{2}$/', $hora_impreso)) {
            $hora_impreso .= ':00';
        }

        $dt_impreso = $row['fechar'] . ' ' . $hora_impreso; // YYYY-mm-dd HH:ii:ss
        $ts_impreso = strtotime($dt_impreso);
    }

    // ✅ Reiniciar SIEMPRE por cada fila
    $puede_eliminar = false;

    if ($ts_impreso > 0) {
        $limite = $ts_impreso + (15 * 60); // ✅ 15 minutos

        // ✅ now debe estar en el rango [inicio, fin]
        if ($now_ts >= $ts_impreso && $now_ts <= $limite) {
            $puede_eliminar = true;
        }
    }

    // =============================
    // ✅ Mantener tu validación de horario
    // =============================
    $eliminar = "";
    if ($time_actual >= $horai && $time_actual <= $horaf) {

        // ✅ SOLO si además está dentro de 15 min
        if ($puede_eliminar) {
            $eliminar = '<a href="actionDelete_fila.php?idrifa=' . (int)$row['idrifa'] . '" 
                            data-toggle="tooltip" data-placement="top" title="Eliminar (15 min)" 
                            class="btn btn-danger">
                            <i class="fa fa-trash" aria-hidden="true"></i>
                         </a>';
        }

        $tabla[] = [
            "codigo"    => $row['codigo'],
            "loteria"   => $row['loteria'],
            "numero"    => $numero_formateado,
            "fechar"    => $row['fechar'].' '.$row['hora_impreso'],
            "fechaj"    => $row['fechaj'],
            "valor"     => $valor_formateado,
            "negocio"   => $row['sucursal'],
            "usuario"   => $row['usuario'],            
            "pagar"     => $valor_formateado,
            "accion"    => $eliminar
        ];

    } else {

        $tabla[] = [
            "codigo"    => $row['codigo'],
            "loteria"   => $row['loteria'],
            "numero"    => $numero_formateado,
            "fechar"    => $row['fechar'].' '.$row['hora_impreso'],
            "fechaj"    => $row['fechaj'],
            "valor"     => $valor_formateado,
            "negocio"   => $row['sucursal'],
            "usuario"   => $row['usuario'],            
            "pagar"     => $valor_formateado,
            "accion"    => ""
        ]; 
    }
}

// Enviar JSON limpio
echo json_encode(["data" => $tabla], JSON_UNESCAPED_UNICODE);
?>
