<?php
session_start();
include("conex.php");

// Verificación de sesión
if (!isset($_SESSION['idusuario'])) {
    die(json_encode(["error" => "Sesión expirada."]));
}

$idusuario = mysqli_real_escape_string($conn, $_SESSION['idusuario']);

// Consulta segura con INNER JOIN
$sql = "SELECT idcifras, cifras, cupo_cifras, condicion
        FROM tbr_cifras        
        WHERE condicion = 1  and idcifras != 1";

$consulta = mysqli_query($conn, $sql);

// Manejo de error en la consulta
if (!$consulta) {
    die(json_encode(["error" => "Error en la consulta: " . mysqli_error($conn)]));
}

// Si no hay resultados, devolver JSON vacío
if (mysqli_num_rows($consulta) == 0) {
    echo json_encode(["data" => []], JSON_UNESCAPED_UNICODE);
    exit;
}

$usuarios_data = [];
while ($row = mysqli_fetch_assoc($consulta)) {
    // Convertir el campo 'activo' en "SI" o "NO"
    //$activo_texto = $row['activo'] == 1 ? "SI" : "NO";

    
    // Acción eliminar
    $eliminar = '<button class="btn btn-danger toggle-condicion" 
                    data-id="' . $row['idcifras'] . '"
                    data-condicion="' . $row['condicion'] . '">
                    <i class="fa fa-trash" aria-hidden="true"></i>
                </button>';

    $editar = '<button class="btn btn-warning toggle-editar" 
                data-id="' . $row['idcifras'] . '"                
                data-cifras="' . $row['cifras'] . '"
                data-cupo="' . $row['cupo_cifras'] . '">
                <i class="fa fa-pencil" aria-hidden="true"></i>
            </button>';

    
    // Construir fila en JSON
    $usuarios_data[] = [        
        "cifras"          => $row['cifras'],
        "cupo"              => $row['cupo_cifras'],        
        "accion"            => $editar.' '.$eliminar
    ];
}

// Enviar JSON limpio
echo json_encode(["data" => $usuarios_data], JSON_UNESCAPED_UNICODE);
?>
