<?php
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

$idusuario = isset($_SESSION['idusuario']) ? (int)$_SESSION['idusuario'] : 0;

require_once __DIR__ . '/conex.php';
if (!isset($conn) || !($conn instanceof mysqli)) {
    echo json_encode(['data' => [], 'success' => false, 'message' => 'Sin conexión BD']); exit;
}
mysqli_set_charset($conn, 'utf8mb4');

// Inicializar variables
$total = 0.0;
$datos = [];

// Consulta SQL con seguridad mejorada
$query = "
SELECT 
    t.idrifa,
    c.cifras,
    t.codigo,
    t.`key`,
    t.numero AS numero_ganador,
    t.valor,
    ts.premio,
    t.tope1,
    t.tope2,
    l.loteria,
    su.suerte,
    t.estado,
    t.fecha_impreso,
    t.fecha,
    u.usuario,
    suc.sucursal
FROM tbr_sorteo s
INNER JOIN tbr_ticket t ON (
    (
        (t.id_cifras = 2 AND RIGHT(t.numero, 3) = RIGHT(s.numero_g, 3))
    )
    AND t.fecha = s.fecha_g
)
INNER JOIN tbr_cifras c       ON c.idcifras   = t.id_cifras
INNER JOIN tbr_loteria l      ON l.idloteria  = t.id_loteria
INNER JOIN tbr_ticket_suerte ts ON ts.id_ticket = t.idrifa AND ts.id_suerte = s.suerte_g
INNER JOIN tbr_suerte su      ON su.idsuerte  = s.suerte_g
INNER JOIN tbr_usuario u      ON u.idusuario  = t.id_usuario
INNER JOIN tbr_sucursal suc   ON suc.idsucursal = u.id_sucursal
WHERE t.condicion = 1 
  AND t.estado = 2 
  AND s.activo = 1 
  AND s.condicion = 1
  AND l.id_pais = 2
  AND l.id_premio = 3
  AND t.id_usuario = ?
  AND DATEDIFF(CURDATE(), t.fecha) > 8
";

$stmt = $conn->prepare($query);
if (!$stmt) {
    echo json_encode(['data' => [], 'success' => false, 'message' => 'Error al preparar consulta']); exit;
}
$stmt->bind_param('i', $idusuario);
$stmt->execute();
$result = $stmt->get_result();

// Zona horaria para el cálculo de días
date_default_timezone_set('America/Guayaquil');

while ($row = $result->fetch_assoc()) {
    // Usar el alias correcto: numero_ganador
    $numero_bruto = (string)($row['numero_ganador'] ?? '');
    $numero_fmt   = str_pad($numero_bruto, 3, '0', STR_PAD_LEFT);

    $valor        = (float)$row['valor'];
    $premio       = (float)$row['premio'];
    $valor_fmt    = number_format($valor, 2, '.', ',');
    $premio_fmt   = number_format($premio, 2, '.', ',');

    // Sumar al total correctamente (numérico)
    $total += $valor;

    // Calcular días vencidos con seguridad
    $fecha_ticket = !empty($row['fecha']) ? new DateTime($row['fecha']) : new DateTime();
    $hoy          = new DateTime();
    $dias_vencidos = $hoy->diff($fecha_ticket)->days;

    $datos[] = [
        "codigo"  => $row['codigo'],
        "loteria" => $row['loteria'],
        "numero"  => $numero_fmt,
        "fechar"  => $row['fecha_impreso'],
        "fechaj"  => $row['fecha'],
        "valor"   => $valor_fmt,
        "negocio" => $row['sucursal'],
        "usuario" => $row['usuario'],
        // corregido "Caducado"
        "pagar"   => "$" . $premio_fmt . " Caducado ({$dias_vencidos} días)",
    ];
}
$stmt->close();

// Enviar JSON correctamente
echo json_encode(
    [
        "data"    => $datos,
        "success" => true,
        "total"   => number_format($total, 2, '.', ','),
    ],
    JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES
);
