<?php
session_start();
$idusuario = isset($_SESSION['idusuario']) ? intval($_SESSION['idusuario']) : 0;

include("conex.php");

// Inicializar variables
$total = 0;
$datos = [];

// Consulta SQL con seguridad mejorada
$query = "SELECT 
        t.idrifa, c.cifras,
        t.codigo, t.`key`, t.numero,
        t.valor, ts.premio, t.tope1, t.tope2,
        l.loteria, su.suerte, t.estado, t.fecha_impreso, t.fecha,
        u.usuario, suc.sucursal
    FROM tbr_sorteo s
    INNER JOIN tbr_ticket t ON (
        (
            (t.id_cifras = 1 AND RIGHT(t.numero, 2) = RIGHT(s.numero_g, 2))           
        )
        AND t.fecha = s.fecha_g
    )
    INNER JOIN tbr_cifras c ON c.idcifras = t.id_cifras
    INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
    INNER JOIN tbr_ticket_suerte ts ON ts.id_ticket = t.idrifa AND ts.id_suerte = s.suerte_g
    INNER JOIN tbr_suerte su ON su.idsuerte = s.suerte_g
    INNER JOIN tbr_usuario u ON u.idusuario = t.id_usuario
    INNER JOIN tbr_sucursal suc ON suc.idsucursal = u.id_sucursal
    WHERE t.condicion = 1 
      AND t.estado = 2 
      AND s.activo = 1 
      AND s.condicion = 1
      AND l.id_pais = 2
	  AND l.id_premio = 2
			AND t.id_usuario = ?
      AND DATEDIFF(CURDATE(), t.fecha) > 8";

// Preparar la consulta
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $idusuario);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

// Procesar resultados
while ($row = mysqli_fetch_assoc($result)) {
    // Formateo de valores
    $numero_formateado = str_pad($row['numero'], 2, '0', STR_PAD_LEFT);
    $valor_formateado = number_format($row['valor'], 2, '.', ',');
    $premio_formateado = number_format($row['premio'], 2, '.', ',');

    // Sumar al total correctamente
    $total += $row['valor'];
    
    $fecha_ganador = new DateTime($row['fecha']);
    $dias_vencidos = (new DateTime())->diff($fecha_ganador)->days;
    
    // Agregar datos al array
    $datos[] = [
        "codigo"    => $row['codigo'],
        "loteria"   => $row['loteria'],
        "numero"    => $numero_formateado,
        "fechar"    => $row['fecha_impreso'],
        "fechaj"    => $row['fecha'],
        "valor"     => $valor_formateado,
        "negocio"   => $row['sucursal'],
        "usuario"   => $row['usuario'],        
        "pagar"     => "$".$premio_formateado." Cadudado ({$dias_vencidos} días)"
    ];
}

// Enviar JSON correctamente
echo json_encode(["data" => $datos], JSON_UNESCAPED_UNICODE);
?>
