<?php
session_start();
include("conex.php");

$id_usuario = $_SESSION['idusuario'];
$idempre = $_POST['idempre'];

// Usamos una consulta preparada para evitar SQL Injection
$sql = "UPDATE tbi_empresa SET condicion = 0 WHERE idempresa = ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, 'i', $idempre);

if (mysqli_stmt_execute($stmt)) {
    // Registramos la actividad en el historial
    $actividad = "Eliminar Empresa";
    $my_ip = $_SERVER["REMOTE_ADDR"];
    date_default_timezone_set('America/Guayaquil');
    $fecha_actual = date('Y/m/d');
    $time_actual = date("H:m:s");

    // Insertamos en el historial
    $insert_historial = mysqli_prepare($conn, "INSERT INTO tbi_historial (fecha, hora, ip, detalle, id_empresa, id_usuario) VALUES (?, ?, ?, ?, ?, ?)");
    mysqli_stmt_bind_param($insert_historial, 'ssssii', $fecha_actual, $time_actual, $my_ip, $actividad, $idempre, $id_usuario);

    if (mysqli_stmt_execute($insert_historial)) {
        // Redirección si la eliminación fue exitosa
        /*echo '<script>
                alert("Empresa eliminada correctamente.");
                window.location.href = "../../views/pages/empresas.php";
              </script>';*/
    } else {
        // Manejo de error si falla la inserción del historial
        echo "Error al registrar la actividad en el historial.";
    }
} else {
    // Manejo de error si falla la eliminación
    echo "Error al eliminar la empresa.";
}
mysqli_stmt_close($stmt);
mysqli_stmt_close($insert_historial);
mysqli_close($conn);
?>