<?php
session_start();
include("conex.php");

// ==========================
//  SESIÓN / VALIDACIONES
// ==========================
if (!isset($_SESSION['idusuario'], $_SESSION['usuario'], $_SESSION['sucursal'])) {
  header('Location: index.php');
  exit();
}

$idusuario   = (int)($_SESSION['idusuario'] ?? 0);
$usuario     = htmlspecialchars($_SESSION['usuario'] ?? '', ENT_QUOTES, 'UTF-8');
$sucursal_id = $_SESSION['sucursal'] ?? null;

if (!is_numeric($sucursal_id)) {
  die("ID de sucursal inválido");
}

if (!isset($conn) || !$conn instanceof mysqli) {
  die("Error: No se pudo establecer la conexión a la base de datos.");
}

// ==========================
//  OBTENER SUCURSAL
// ==========================
$query = "SELECT sucursal FROM tbr_sucursal WHERE idsucursal = ?";
$stmt  = mysqli_prepare($conn, $query);
if ($stmt) {
  mysqli_stmt_bind_param($stmt, "i", $sucursal_id);
  mysqli_stmt_execute($stmt);
  $result = mysqli_stmt_get_result($stmt);
  if ($row = mysqli_fetch_assoc($result)) {
    $sucursal = $row['sucursal'];
  } else {
    die("Sucursal no encontrada.");
  }
  mysqli_stmt_close($stmt);
} else {
  die("Error en la preparación de la consulta (sucursal).");
}

// ==========================
//  PERMISOS DEL USUARIO
// ==========================
$queryu = "SELECT venta, pago FROM tbr_usuario WHERE idusuario = ?";
$stmtu  = mysqli_prepare($conn, $queryu);
if ($stmtu) {
  mysqli_stmt_bind_param($stmtu, "i", $idusuario);
  mysqli_stmt_execute($stmtu);
  $resultu = mysqli_stmt_get_result($stmtu);
  if ($row = mysqli_fetch_assoc($resultu)) {
    $venta = (int)$row['venta'];
    $pago  = (int)$row['pago'];
  } else {
    die("Usuario no encontrado");
  }
  mysqli_stmt_close($stmtu);
} else {
  die("Error en la preparación de la consulta (usuario).");
}

if ($venta != 1) {
  header("Location: pago.php");
  exit;
}

// ==========================
//  FECHA / TIMEZONE
// ==========================
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d');

// ----------------------------------------------------
// TARJETAS: Total ventas hoy (1/2/3 cifras) ECUADOR
// ----------------------------------------------------
$cifrasVentasHoy = [
  ['id_cifras' => 1, 'modal' => '#ventasModal',   'titulo' => 'Total dos cifras',    'color' => 'bg-warning'],
  ['id_cifras' => 2, 'modal' => '#ventasModal3d', 'titulo' => 'Total tres cifras',   'color' => 'bg-primary'],
  ['id_cifras' => 3, 'modal' => '#ventasModal4d', 'titulo' => 'Total cuatro cifras', 'color' => 'bg-success'],
];

$sqlVentasHoyEc = "
  SELECT t.id_cifras, SUM(t.valor) AS total 
  FROM tbr_ticket t
  INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
  WHERE t.condicion = 1 
    AND t.estado = 2 
    AND t.id_usuario = {$idusuario}
    AND l.id_pais = 1
    AND l.id_premio = 1
    AND t.fecha_impreso = '{$fecha_actual}'
  GROUP BY t.id_cifras
";
$resVentasHoyEc = mysqli_query($conn, $sqlVentasHoyEc);
$totalesHoy     = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resVentasHoyEc) {
  while ($r = mysqli_fetch_assoc($resVentasHoyEc)) {
    $idc = (int)$r['id_cifras'];
    if ($idc >= 1 && $idc <= 3) {
      $totalesHoy[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Total ventas hoy ARGENTINA MATUTINA
// ----------------------------------------------------
$cifrasVentasHoyAr = [
  ['id_cifras' => 1, 'modal' => '#ventasModalAr',   'titulo' => 'Total dos cifras',    'color' => 'bg-warning'],
  ['id_cifras' => 2, 'modal' => '#ventasModal3dAr', 'titulo' => 'Total tres cifras',   'color' => 'bg-primary'],
  ['id_cifras' => 3, 'modal' => '#ventasModal4dAr', 'titulo' => 'Total cuatro cifras', 'color' => 'bg-success'],
];

$sqlVentasHoyAr = "
  SELECT t.id_cifras, SUM(t.valor) AS total 
  FROM tbr_ticket t
  INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
  WHERE t.condicion = 1 
    AND t.estado = 2 
    AND t.id_usuario = {$idusuario}
    AND l.id_pais = 2
    AND l.id_premio = 2
    AND t.fecha_impreso = '{$fecha_actual}'
  GROUP BY t.id_cifras
";
$resVentasHoyAr = mysqli_query($conn, $sqlVentasHoyAr);
$totalesHoyAr   = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resVentasHoyAr) {
  while ($r = mysqli_fetch_assoc($resVentasHoyAr)) {
    $idc = (int)$r['id_cifras'];
    if ($idc >= 1 && $idc <= 3) {
      $totalesHoyAr[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Total ventas hoy ARGENTINA VESPERTINA
// ----------------------------------------------------
$cifrasVentasHoyArV = [
  ['id_cifras' => 1, 'modal' => '#ventasModalArV',   'titulo' => 'Total dos cifras',    'color' => 'bg-warning'],
  ['id_cifras' => 2, 'modal' => '#ventasModal3dArV', 'titulo' => 'Total tres cifras',   'color' => 'bg-primary'],
  ['id_cifras' => 3, 'modal' => '#ventasModal4dArV', 'titulo' => 'Total cuatro cifras', 'color' => 'bg-success'],
];

$sqlVentasHoyArV = "
  SELECT t.id_cifras, SUM(t.valor) AS total 
  FROM tbr_ticket t
  INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
  WHERE t.condicion = 1 
    AND t.estado = 2 
    AND t.id_usuario = {$idusuario}
    AND l.id_pais = 2
    AND l.id_premio = 3
    AND t.fecha_impreso = '{$fecha_actual}'
  GROUP BY t.id_cifras
";
$resVentasHoyArV = mysqli_query($conn, $sqlVentasHoyArV);
$totalesHoyArV   = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resVentasHoyArV) {
  while ($r = mysqli_fetch_assoc($resVentasHoyArV)) {
    $idc = (int)$r['id_cifras'];
    if ($idc >= 1 && $idc <= 3) {
      $totalesHoyArV[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ventas SIN jugar ECUADOR
// ----------------------------------------------------
$cifrasSinJugarEc = [
  ['id_cifras' => 1, 'modal' => '#ventassinModal2c', 'titulo' => 'Total dos cifras',    'color' => 'bg-warning'],
  ['id_cifras' => 2, 'modal' => '#ventassinModal3c', 'titulo' => 'Total tres cifras',   'color' => 'bg-primary'],
  ['id_cifras' => 3, 'modal' => '#ventassinModal4c', 'titulo' => 'Total cuatro cifras', 'color' => 'bg-success'],
];

$sqlSinJugarEc = "
  SELECT t.id_cifras, SUM(t.valor) AS total 
  FROM tbr_ticket t
  INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
  WHERE t.condicion = 1
    AND t.estado >= 2
    AND t.id_usuario = {$idusuario}
    AND t.fecha_impreso = '{$fecha_actual}'
    AND l.id_pais = 1
    AND l.id_premio = 1
    AND t.fecha > '{$fecha_actual}'
  GROUP BY t.id_cifras
";
$resSinJugarEc     = mysqli_query($conn, $sqlSinJugarEc);
$totalesSinJugarEc = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resSinJugarEc) {
  while ($r = mysqli_fetch_assoc($resSinJugarEc)) {
    $idc = (int)$r['id_cifras'];
    if ($idc >= 1 && $idc <= 3) {
      $totalesSinJugarEc[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ventas SIN jugar ARGENTINA MATUTINA
// ----------------------------------------------------
$cifrasSinJugarAr = [
  ['id_cifras' => 1, 'modal' => '#ventassinModal2cAr', 'titulo' => 'Total dos cifras',    'color' => 'bg-warning'],
  ['id_cifras' => 2, 'modal' => '#ventassinModal3cAr', 'titulo' => 'Total tres cifras',   'color' => 'bg-primary'],
  ['id_cifras' => 3, 'modal' => '#ventassinModal4cAr', 'titulo' => 'Total cuatro cifras', 'color' => 'bg-success'],
];

$sqlSinJugarAr = "
  SELECT t.id_cifras, SUM(t.valor) AS total 
  FROM tbr_ticket t
  INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
  WHERE t.condicion = 1
    AND t.estado >= 2
    AND t.id_usuario = {$idusuario}
    AND t.fecha_impreso = '{$fecha_actual}'
    AND l.id_pais = 2
    AND l.id_premio = 2
    AND t.fecha > '{$fecha_actual}'
  GROUP BY t.id_cifras
";
$resSinJugarAr     = mysqli_query($conn, $sqlSinJugarAr);
$totalesSinJugarAr = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resSinJugarAr) {
  while ($r = mysqli_fetch_assoc($resSinJugarAr)) {
    $idc = (int)$r['id_cifras'];
    if ($idc >= 1 && $idc <= 3) {
      $totalesSinJugarAr[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ventas SIN jugar ARGENTINA VESPERTINA
// ----------------------------------------------------
$cifrasSinJugarArV = [
  ['id_cifras' => 1, 'modal' => '#ventassinModal2cArV', 'titulo' => 'Total dos cifras',    'color' => 'bg-warning'],
  ['id_cifras' => 2, 'modal' => '#ventassinModal3cArV', 'titulo' => 'Total tres cifras',   'color' => 'bg-primary'],
  ['id_cifras' => 3, 'modal' => '#ventassinModal4cArV', 'titulo' => 'Total cuatro cifras', 'color' => 'bg-success'],
];

$sqlSinJugarArV = "
  SELECT t.id_cifras, SUM(t.valor) AS total 
  FROM tbr_ticket t
  INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
  WHERE t.condicion = 1
    AND t.estado >= 2
    AND t.id_usuario = {$idusuario}
    AND t.fecha_impreso = '{$fecha_actual}'
    AND l.id_pais = 2
    AND l.id_premio = 3
    AND t.fecha > '{$fecha_actual}'
  GROUP BY t.id_cifras
";
$resSinJugarArV     = mysqli_query($conn, $sqlSinJugarArV);
$totalesSinJugarArV = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resSinJugarArV) {
  while ($r = mysqli_fetch_assoc($resSinJugarArV)) {
    $idc = (int)$r['id_cifras'];
    if ($idc >= 1 && $idc <= 3) {
      $totalesSinJugarArV[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ganadores PENDIENTES últimos 8 días ECUADOR
// ----------------------------------------------------
$cifrasPend = [
  ['id_cifras' => 1, 'modal' => '#pendientesModal2c',  'titulo' => 'Total dos cifras',    'color' => 'bg-warning'],
  ['id_cifras' => 2, 'modal' => '#pendientesModal3c',  'titulo' => 'Total tres cifras',   'color' => 'bg-primary'],
  ['id_cifras' => 3, 'modal' => '#pendientesModal4c',  'titulo' => 'Total cuatro cifras', 'color' => 'bg-success'],
];

$sqlPendEc = "
  SELECT 
    t.id_cifras,
    SUM(ts.premio) AS total
  FROM tbr_sorteo AS s
  INNER JOIN tbr_ticket AS t 
    ON t.id_loteria = s.id_loteria
   AND t.fecha      = s.fecha_g
   AND (
        (t.id_cifras = 1 AND t.numero = RIGHT(s.numero_g, 2)) OR
        (t.id_cifras = 2 AND t.numero = RIGHT(s.numero_g, 3)) OR
        (t.id_cifras = 3 AND t.numero = s.numero_g)
       )
  INNER JOIN tbr_cifras   AS c   ON c.idcifras    = t.id_cifras
  INNER JOIN tbr_loteria  AS l   ON l.idloteria   = t.id_loteria
  INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa
  INNER JOIN tbr_usuario  AS u   ON u.idusuario   = t.id_usuario
  INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
  WHERE t.condicion   = 1 
    AND t.estado      = 2
    AND s.activo      = 1
    AND s.condicion   = 1
    AND l.id_pais     = 1
    AND l.id_premio   = 1
    AND t.id_usuario  = {$idusuario}
    AND ts.id_suerte  = s.suerte_g
    AND s.fecha_g BETWEEN CURDATE() - INTERVAL 8 DAY AND CURDATE()
  GROUP BY t.id_cifras
";

$resPendEc     = mysqli_query($conn, $sqlPendEc);
$totalesPendEc = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resPendEc) {
  while ($r = mysqli_fetch_assoc($resPendEc)) {
    $idc = (int)($r['id_cifras'] ?? 0);
    if ($idc >= 1 && $idc <= 3) {
      $totalesPendEc[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ganadores PENDIENTES últimos 8 días ARGENTINA MATUTINA
// ----------------------------------------------------
$cifrasPendAr = [
  ['id_cifras' => 1, 'modal' => '#pendientesModal2cAr',  'titulo' => 'Total dos cifras',    'color' => 'bg-warning'],
  ['id_cifras' => 2, 'modal' => '#pendientesModal3cAr',  'titulo' => 'Total tres cifras',   'color' => 'bg-primary'],
  ['id_cifras' => 3, 'modal' => '#pendientesModal4cAr',  'titulo' => 'Total cuatro cifras', 'color' => 'bg-success'],
];

$sqlPendAr = "
  SELECT 
    t.id_cifras,
    SUM(ts.premio) AS total
  FROM tbr_sorteo AS s
  INNER JOIN tbr_ticket AS t 
    ON t.id_loteria = s.id_loteria
   AND t.fecha      = s.fecha_g
   AND (
        (t.id_cifras = 1 AND t.numero = RIGHT(s.numero_g, 2)) OR
        (t.id_cifras = 2 AND t.numero = RIGHT(s.numero_g, 3)) OR
        (t.id_cifras = 3 AND t.numero = s.numero_g)
       )
  INNER JOIN tbr_cifras   AS c   ON c.idcifras    = t.id_cifras
  INNER JOIN tbr_loteria  AS l   ON l.idloteria   = t.id_loteria
  INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa
  INNER JOIN tbr_usuario  AS u   ON u.idusuario   = t.id_usuario
  INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
  WHERE t.condicion   = 1 
    AND t.estado      = 2
    AND s.activo      = 1
    AND s.condicion   = 1
    AND l.id_pais     = 2
    AND l.id_premio   = 2
    AND t.id_usuario  = {$idusuario}
    AND ts.id_suerte  = s.suerte_g
    AND s.fecha_g BETWEEN CURDATE() - INTERVAL 8 DAY AND CURDATE()
  GROUP BY t.id_cifras
";

$resPendAr     = mysqli_query($conn, $sqlPendAr);
$totalesPendAr = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resPendAr) {
  while ($r = mysqli_fetch_assoc($resPendAr)) {
    $idc = (int)($r['id_cifras'] ?? 0);
    if ($idc >= 1 && $idc <= 3) {
      $totalesPendAr[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ganadores PENDIENTES últimos 8 días ARGENTINA VESPERTINA
// ----------------------------------------------------
$cifrasPendArV = [
  ['id_cifras' => 1, 'modal' => '#pendientesModal2cArV',  'titulo' => 'Total dos cifras',    'color' => 'bg-warning'],
  ['id_cifras' => 2, 'modal' => '#pendientesModal3cArV',  'titulo' => 'Total tres cifras',   'color' => 'bg-primary'],
  ['id_cifras' => 3, 'modal' => '#pendientesModal4cArV',  'titulo' => 'Total cuatro cifras', 'color' => 'bg-success'],
];

$sqlPendArV = "
  SELECT 
    t.id_cifras,
    SUM(ts.premio) AS total
  FROM tbr_sorteo AS s
  INNER JOIN tbr_ticket AS t 
    ON t.id_loteria = s.id_loteria
   AND t.fecha      = s.fecha_g
   AND (
        (t.id_cifras = 1 AND t.numero = RIGHT(s.numero_g, 2)) OR
        (t.id_cifras = 2 AND t.numero = RIGHT(s.numero_g, 3)) OR
        (t.id_cifras = 3 AND t.numero = s.numero_g)
       )
  INNER JOIN tbr_cifras   AS c   ON c.idcifras    = t.id_cifras
  INNER JOIN tbr_loteria  AS l   ON l.idloteria   = t.id_loteria
  INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa
  INNER JOIN tbr_usuario  AS u   ON u.idusuario   = t.id_usuario
  INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
  WHERE t.condicion   = 1 
    AND t.estado      = 2
    AND s.activo      = 1
    AND s.condicion   = 1
    AND l.id_pais     = 2
    AND l.id_premio   = 3
    AND t.id_usuario  = {$idusuario}
    AND ts.id_suerte  = s.suerte_g
    AND s.fecha_g BETWEEN CURDATE() - INTERVAL 8 DAY AND CURDATE()
  GROUP BY t.id_cifras
";

$resPendArV     = mysqli_query($conn, $sqlPendArV);
$totalesPendArV = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resPendArV) {
  while ($r = mysqli_fetch_assoc($resPendArV)) {
    $idcArV = (int)($r['id_cifras'] ?? 0);
    if ($idcArV >= 1 && $idcArV <= 3) {
      $totalesPendArV[$idcArV] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ganadores PAGADOS ECUADOR
// ----------------------------------------------------
$catsPagadosEc = [
  1 => ['color' => 'bg-warning', 'modal' => '#pagadoModal2c', 'titulo' => 'Total dos cifras'],
  2 => ['color' => 'bg-primary', 'modal' => '#pagadoModal3c', 'titulo' => 'Total tres cifras'],
  3 => ['color' => 'bg-success', 'modal' => '#pagadoModal4c', 'titulo' => 'Total cuatro cifras'],
];

$sqlPagadosEc = "
  SELECT t.id_cifras, SUM(ts.premio) AS total
  FROM tbr_sorteo AS s
  INNER JOIN tbr_ticket AS t 
    ON (
      (t.id_cifras = 1 AND t.numero = RIGHT(s.numero_g, 2)) OR
      (t.id_cifras = 2 AND t.numero = RIGHT(s.numero_g, 3)) OR
      (t.id_cifras = 3 AND t.numero = s.numero_g)
    )
   AND t.fecha = s.fecha_g
  INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa
  INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
  INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
  INNER JOIN tbr_loteria AS l ON l.idloteria = s.id_loteria
  WHERE t.condicion = 1 
    AND t.estado 	= 3
    AND s.activo 	= 1
    AND s.condicion = 1
    AND l.id_pais 	= 1
	AND l.id_premio = 1
    AND t.id_usuario = {$idusuario}
    AND ts.id_suerte = s.suerte_g
  GROUP BY t.id_cifras
";
$resPagEc         = mysqli_query($conn, $sqlPagadosEc);
$totalesPagadosEc = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resPagEc) {
  while ($r = mysqli_fetch_assoc($resPagEc)) {
    $idc = (int)($r['id_cifras'] ?? 0);
    if ($idc >= 1 && $idc <= 3) {
      $totalesPagadosEc[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ganadores PAGADOS ARGENTINA MATUTINA
// ----------------------------------------------------
$catsPagadosAr = [
  1 => ['color' => 'bg-warning', 'modal' => '#pagadoModal2cAr', 'titulo' => 'Total dos cifras'],
  2 => ['color' => 'bg-primary', 'modal' => '#pagadoModal3cAr', 'titulo' => 'Total tres cifras'],
  3 => ['color' => 'bg-success', 'modal' => '#pagadoModal4cAr', 'titulo' => 'Total cuatro cifras'],
];

$sqlPagadosAr = "
  SELECT t.id_cifras, SUM(ts.premio) AS total
  FROM tbr_sorteo AS s
  INNER JOIN tbr_ticket AS t 
    ON (
      (t.id_cifras = 1 AND t.numero = RIGHT(s.numero_g, 2)) OR
      (t.id_cifras = 2 AND t.numero = RIGHT(s.numero_g, 3)) OR
      (t.id_cifras = 3 AND t.numero = s.numero_g)
    )
   AND t.fecha = s.fecha_g
  INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa
  INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
  INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
  INNER JOIN tbr_loteria AS l ON l.idloteria = s.id_loteria
  WHERE t.condicion = 1 
    AND t.estado 	= 3
    AND s.activo 	= 1
    AND s.condicion = 1
    AND l.id_pais 	= 2
	AND l.id_premio	= 2
    AND t.id_usuario = {$idusuario}
    AND ts.id_suerte = s.suerte_g
  GROUP BY t.id_cifras
";
$resPagAr         = mysqli_query($conn, $sqlPagadosAr);
$totalesPagadosAr = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resPagAr) {
  while ($r = mysqli_fetch_assoc($resPagAr)) {
    $idc = (int)($r['id_cifras'] ?? 0);
    if ($idc >= 1 && $idc <= 3) {
      $totalesPagadosAr[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ganadores PAGADOS ARGENTINA VESPERTINA
// ----------------------------------------------------
$catsPagadosArV = [
  1 => ['color' => 'bg-warning', 'modal' => '#pagadoModal2cArV', 'titulo' => 'Total dos cifras'],
  2 => ['color' => 'bg-primary', 'modal' => '#pagadoModal3cArV', 'titulo' => 'Total tres cifras'],
  3 => ['color' => 'bg-success', 'modal' => '#pagadoModal4cArV', 'titulo' => 'Total cuatro cifras'],
];

$sqlPagadosArV = "
  SELECT t.id_cifras, SUM(ts.premio) AS total
  FROM tbr_sorteo AS s
  INNER JOIN tbr_ticket AS t 
    ON (
      (t.id_cifras = 1 AND t.numero = RIGHT(s.numero_g, 2)) OR
      (t.id_cifras = 2 AND t.numero = RIGHT(s.numero_g, 3)) OR
      (t.id_cifras = 3 AND t.numero = s.numero_g)
    )
   AND t.fecha = s.fecha_g
  INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa
  INNER JOIN tbr_usuario AS u ON u.idusuario = t.id_usuario
  INNER JOIN tbr_sucursal AS suc ON suc.idsucursal = u.id_sucursal
  INNER JOIN tbr_loteria AS l ON l.idloteria = s.id_loteria
  WHERE t.condicion = 1 
    AND t.estado 	= 3
    AND s.activo 	= 1
    AND s.condicion = 1
    AND l.id_pais 	= 2
	AND l.id_premio	= 2
    AND t.id_usuario = {$idusuario}
    AND ts.id_suerte = s.suerte_g
  GROUP BY t.id_cifras
";
$resPagArV         = mysqli_query($conn, $sqlPagadosArV);
$totalesPagadosArV = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resPagArV) {
  while ($r = mysqli_fetch_assoc($resPagArV)) {
    $idcV = (int)($r['id_cifras'] ?? 0);
    if ($idcV >= 1 && $idcV <= 3) {
      $totalesPagadosArV[$idcV] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ganadores CADUCADOS ECUADOR
// ----------------------------------------------------
$catsCad = [
  1 => ['color' => 'bg-warning', 'modal' => '#caducadoModal2c', 'titulo' => 'Total dos cifras'],
  2 => ['color' => 'bg-primary', 'modal' => '#caducadoModal3c', 'titulo' => 'Total tres cifras'],
  3 => ['color' => 'bg-success', 'modal' => '#caducadoModal4c', 'titulo' => 'Total cuatro cifras'],
];

$sqlCadEc = "
  SELECT t.id_cifras, SUM(ts.premio) AS total
  FROM tbr_sorteo s
  INNER JOIN tbr_ticket t ON (
    (
      (t.id_cifras = 1 AND RIGHT(t.numero, 2) = RIGHT(s.numero_g, 2)) OR 
      (t.id_cifras = 2 AND RIGHT(t.numero, 3) = RIGHT(s.numero_g, 3)) OR 
      (t.id_cifras = 3 AND t.numero = s.numero_g)       
    )
    AND t.fecha = s.fecha_g
  )
  INNER JOIN tbr_cifras c ON c.idcifras = t.id_cifras
  INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
  INNER JOIN tbr_ticket_suerte ts ON ts.id_ticket = t.idrifa AND ts.id_suerte = s.suerte_g
  INNER JOIN tbr_suerte su ON su.idsuerte = s.suerte_g
  INNER JOIN tbr_usuario u ON u.idusuario = t.id_usuario
  INNER JOIN tbr_sucursal suc ON suc.idsucursal = u.id_sucursal
  WHERE t.condicion = 1 
    AND t.estado = 2 
    AND s.activo = 1 
    AND s.condicion = 1
    AND l.id_pais = 1	
    AND l.id_premio   = 1
    AND t.id_usuario = {$idusuario}
    AND DATEDIFF(CURDATE(), t.fecha) > 8
  GROUP BY t.id_cifras
";
$resCadEc   = mysqli_query($conn, $sqlCadEc);
$totalesCad = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resCadEc) {
  while ($r = mysqli_fetch_assoc($resCadEc)) {
    $idc = (int)($r['id_cifras'] ?? 0);
    if ($idc >= 1 && $idc <= 3) {
      $totalesCad[$idc] = (float)($r['total'] ?? 0);
    }
  }
}

// ----------------------------------------------------
// TARJETAS: Ganadores CADUCADOS ARGENTINA MATUTINA
// ----------------------------------------------------
$catsCadAr = [
  1 => ['color' => 'bg-warning', 'modal' => '#caducadoModal2cAr', 'titulo' => 'Total dos cifras'],
  2 => ['color' => 'bg-primary', 'modal' => '#caducadoModal3cAr', 'titulo' => 'Total tres cifras'],
  3 => ['color' => 'bg-success', 'modal' => '#caducadoModal4cAr', 'titulo' => 'Total cuatro cifras'],
];

$sqlCadAr = "
  SELECT t.id_cifras, SUM(ts.premio) AS total
  FROM tbr_sorteo s
  INNER JOIN tbr_ticket t ON (
    (
      (t.id_cifras = 1 AND RIGHT(t.numero, 2) = RIGHT(s.numero_g, 2)) OR 
      (t.id_cifras = 2 AND RIGHT(t.numero, 3) = RIGHT(s.numero_g, 3)) OR 
      (t.id_cifras = 3 AND t.numero = s.numero_g)       
    )
    AND t.fecha = s.fecha_g
  )
  INNER JOIN tbr_cifras c ON c.idcifras = t.id_cifras
  INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
  INNER JOIN tbr_ticket_suerte ts ON ts.id_ticket = t.idrifa AND ts.id_suerte = s.suerte_g
  INNER JOIN tbr_suerte su ON su.idsuerte = s.suerte_g
  INNER JOIN tbr_usuario u ON u.idusuario = t.id_usuario
  INNER JOIN tbr_sucursal suc ON suc.idsucursal = u.id_sucursal
  WHERE t.condicion = 1 
    AND t.estado = 2 
    AND s.activo = 1 
    AND s.condicion = 1
    AND l.id_pais = 2
	AND l.id_premio   = 2
    AND t.id_usuario = {$idusuario}
    AND DATEDIFF(CURDATE(), t.fecha) > 8
  GROUP BY t.id_cifras
";
$resCadAr      = mysqli_query($conn, $sqlCadAr);
$totalesCadAr  = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resCadAr) {
  while ($r = mysqli_fetch_assoc($resCadAr)) {
    $idc = (int)($r['id_cifras'] ?? 0);
    if ($idc >= 1 && $idc <= 3) {
      $totalesCadAr[$idc] = (float)($r['total'] ?? 0);
    }
  }
}
// ----------------------------------------------------
// TARJETAS: Ganadores CADUCADOS ARGENTINA VESPERTINA
// ----------------------------------------------------
$catsCadArV = [
  1 => ['color' => 'bg-warning', 'modal' => '#caducadoModal2cArV', 'titulo' => 'Total dos cifras'],
  2 => ['color' => 'bg-primary', 'modal' => '#caducadoModal3cArV', 'titulo' => 'Total tres cifras'],
  3 => ['color' => 'bg-success', 'modal' => '#caducadoModal4cArV', 'titulo' => 'Total cuatro cifras'],
];

$sqlCadArV = "
  SELECT t.id_cifras, SUM(ts.premio) AS total
  FROM tbr_sorteo s
  INNER JOIN tbr_ticket t ON (
    (
      (t.id_cifras = 1 AND RIGHT(t.numero, 2) = RIGHT(s.numero_g, 2)) OR 
      (t.id_cifras = 2 AND RIGHT(t.numero, 3) = RIGHT(s.numero_g, 3)) OR 
      (t.id_cifras = 3 AND t.numero = s.numero_g)       
    )
    AND t.fecha = s.fecha_g
  )
  INNER JOIN tbr_cifras c ON c.idcifras = t.id_cifras
  INNER JOIN tbr_loteria l ON l.idloteria = t.id_loteria
  INNER JOIN tbr_ticket_suerte ts ON ts.id_ticket = t.idrifa AND ts.id_suerte = s.suerte_g
  INNER JOIN tbr_suerte su ON su.idsuerte = s.suerte_g
  INNER JOIN tbr_usuario u ON u.idusuario = t.id_usuario
  INNER JOIN tbr_sucursal suc ON suc.idsucursal = u.id_sucursal
  WHERE t.condicion = 1 
    AND t.estado = 2 
    AND s.activo = 1 
    AND s.condicion = 1
    AND l.id_pais = 2
	AND l.id_premio   = 3
    AND t.id_usuario = {$idusuario}
    AND DATEDIFF(CURDATE(), t.fecha) > 8
  GROUP BY t.id_cifras
";
$resCadArV      = mysqli_query($conn, $sqlCadArV);
$totalesCadArV  = [1 => 0.0, 2 => 0.0, 3 => 0.0];
if ($resCadArV) {
  while ($r = mysqli_fetch_assoc($resCadArV)) {
    $idcV = (int)($r['id_cifras'] ?? 0);
    if ($idcV >= 1 && $idcV <= 3) {
      $totalesCadArV[$idcV] = (float)($r['total'] ?? 0);
    }
  }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Sistema de Gestión - Panel de pagos</title>
  <link rel="shortcut icon" href="../resources/img/crud.ico">

  <!-- Bootstrap / FontAwesome / jQuery -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <!-- DayJS -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/dayjs/1.11.7/dayjs.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/dayjs/1.11.7/locale/es.min.js"></script>

  <!-- Bootstrap Select / Summernote / SweetAlert2 -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/css/bootstrap-select.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">

  <!-- DataTables -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

  <style>
    .form-control, .selectpicker, .btn { font-size: 1.5em; min-height: 2.5em; }
    body { background-color: #f4f6f9; }
    .navbar { margin-bottom: 20px; }
    .content { padding: 1rem; }
    .sidebar {
      width: 150px; background: #343a40; padding: 20px; height: 100vh;
      position: fixed; left: 0; top: 0; display: flex; flex-direction: column; align-items: center;
    }
    .sidebar a { color:#fff; text-decoration:none; padding:15px; width:100%; display:flex; flex-direction:column; align-items:center; transition: background .3s, transform .2s; }
    .sidebar a:hover { background: rgba(255,255,255,.1); transform: scale(1.05); border-radius: 8px; }
    .sidebar .active { font-weight: bold; color: #17a2b8; }
    .sidebar.show { transform: translateX(0); }
    .main-content { margin-left: 0; transition: margin-left .3s; }
    @media (min-width: 769px){ .main-content { margin-left: 150px; } }
    .loader { position: fixed; top:0; left:0; width:100%; height:100%; background: rgba(0,0,0,.5); display:flex; align-items:center; justify-content:center; color:#fff; font-size:20px; font-weight:bold; z-index:2000; }
    .loader::before{ content:''; width:40px; height:40px; border:5px solid #fff; border-radius:50%; border-top-color:transparent; animation: spin 1s linear infinite; }
    @keyframes spin { to { transform: rotate(360deg); } }
    .card-hover { transition: transform .3s ease, box-shadow .3s ease; }
    .card-hover:hover { transform: scale(1.08); box-shadow:0 8px 20px rgba(0,0,0,.15); }
  </style>
</head>
<body>

  <!-- SIDEBAR -->
  <nav class="sidebar" id="sidebar">
    <ul class="nav flex-column text-center">
      <li class="nav-item"><a href="dashboard.php"><i class="fa fa-tachometer-alt"></i> Dashboard</a></li>
      <?php if ($venta == 1): ?>
      <li class="nav-item">
        <a href="ventas.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF'])=='ventas.php'?'active':''; ?>">
          <i class="fas fa-shopping-cart fa-2x"></i><div class="text-uppercase" style="font-size:12px;">Ventas</div>
        </a>
      </li>
      <?php endif; ?>
      <?php if ($pago == 1): ?>
      <li class="nav-item">
        <a href="pago.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF'])=='pago.php'?'active':''; ?>">
          <i class="fas fa-money-check-alt fa-2x"></i><div class="text-uppercase" style="font-size:12px;">Pago</div>
        </a>
      </li>
      <?php endif; ?>
      <li class="nav-item"><a href="historial.php" class="nav-link"><i class="fa fa-history fa-2x"></i><div class="text-uppercase" style="font-size:12px;">Historial</div></a></li>
      <li class="nav-item"><a href="reporte_usu2.php" class="nav-link"><i class="fa fa-cubes fa-2x"></i><div class="text-uppercase" style="font-size:12px;">Utilidad dos cifras</div></a></li>
      <li class="nav-item"><a href="reporte_usu3.php" class="nav-link"><i class="fa fa-cubes fa-2x"></i><div class="text-uppercase" style="font-size:12px;">Utilidad tres cifras</div></a></li>
      <li class="nav-item"><a href="reporte_usu4.php" class="nav-link"><i class="fa fa-cubes fa-2x"></i><div class="text-uppercase" style="font-size:12px;">Utilidad cuatro cifras</div></a></li>
      <li class="nav-item"><a href="javascript:void(0)" class="nav-link" onclick="cerrar();"><i class="fas fa-sign-out-alt fa-2x"></i><div class="text-uppercase" style="font-size:12px;">Cerrar Sesión</div></a></li>
    </ul>
  </nav>

  <!-- MAIN CONTENT -->
  <div class="main-content" id="mainContent">
    <nav class="navbar navbar-expand-lg navbar-light bg-light">
      <div class="container-fluid">
        <button class="navbar-toggler" type="button" onclick="toggleSidebar()"><span class="navbar-toggler-icon"></span></button>
        <a class="navbar-brand" href="#"><i class="fas fa-tachometer-alt"></i> Panel de pagos</a>
        <div class="collapse navbar-collapse">
          <ul class="navbar-nav ms-auto">
            <li class="nav-item"><a class="nav-link active"><i class="fa fa-store"></i> <?php echo " ".$sucursal; ?></a></li>
            <li class="nav-item"><a class="nav-link active"><i class="fa fa-user-secret"></i> <?php echo " ".$usuario; ?></a></li>
            <li class="nav-item"><a class="nav-link"><i class="fa fa-calendar-check"></i> <span id="fechaActual"></span></a></li>
            <li class="nav-item d-none d-md-block"><a class="nav-link"><em class="fas fa-clock text-mac"></em>&nbsp;<span id="horaActual"></span></a></li>
          </ul>
        </div>
      </div>
    </nav>

<?php
// === Mapear por id_cifras para unificar VENTAS HOY ===
$mapEc   = [];
$mapArM  = [];
$mapArV  = [];
foreach ($cifrasVentasHoy as $c)    { $mapEc[$c['id_cifras']]   = $c; }
foreach ($cifrasVentasHoyAr as $c)  { $mapArM[$c['id_cifras']]  = $c; }
foreach ($cifrasVentasHoyArV as $c) { $mapArV[$c['id_cifras']]  = $c; }
?>

<!-- TARJETAS UNIFICADAS: VENTAS HOY -->
<div class="row justify-content-center">
  <?php foreach ($mapEc as $id_cifras => $cEc): 
    $cArM = $mapArM[$id_cifras] ?? null;
    $cArV = $mapArV[$id_cifras] ?? null;

    $totalEc  = (float)($totalesHoy[$id_cifras]    ?? 0);
    $totalArM = (float)($totalesHoyAr[$id_cifras]  ?? 0);
    $totalArV = (float)($totalesHoyArV[$id_cifras] ?? 0);

    $totalGeneral = $totalEc + $totalArM + $totalArV;
  ?>
  <div class="col-12 col-md-4 col-lg-4 mb-3">
    <div class="card card-hover border border-4 <?= $cEc['color'] ?>">
      <div class="d-flex align-items-center <?= $cEc['color'] ?> text-white p-2">
        <i class="fas fa-dollar-sign fa-2x me-2"></i>
        <div class="flex-grow-1">
          <div class="fw-bold text-uppercase">
            Ventas hoy - <?= htmlspecialchars($cEc['titulo'] ?? ('Cifras '.$id_cifras), ENT_QUOTES, 'UTF-8'); ?>
          </div>
          <div class="small text-white-50">Total (Ec + Ar Mat + Ar Vesp)</div>
        </div>
        <div class="ms-2 text-end">
          <div class="h4 m-0 fw-bold"><?= number_format($totalGeneral, 2, '.', ','); ?></div>
        </div>
      </div>
      <div class="bg-light p-2 rounded-bottom">

        <!-- ECUADOR -->
        <div class="d-flex justify-content-between align-items-center mb-2 px-2 py-1 rounded"
             style="cursor:pointer;"
             data-bs-toggle="modal"
             data-bs-target="<?= $cEc['modal']; ?>">
          <span class="text-muted small text-uppercase">Ecuador</span>
          <span class="h5 m-0 text-dark fw-bold"><?= number_format($totalEc, 2, '.', ','); ?></span>
        </div>

        <!-- ARGENTINA MATUTINA -->
        <?php if ($cArM): ?>
        <div class="d-flex justify-content-between align-items-center mb-2 px-2 py-1 rounded"
             style="cursor:pointer;"
             data-bs-toggle="modal"
             data-bs-target="<?= $cArM['modal']; ?>">
          <span class="text-muted small text-uppercase">Argentina Matutina</span>
          <span class="h6 m-0 text-dark fw-bold"><?= number_format($totalArM, 2, '.', ','); ?></span>
        </div>
        <?php endif; ?>

        <!-- ARGENTINA VESPERTINA -->
        <?php if ($cArV): ?>
        <div class="d-flex justify-content-between align-items-center px-2 py-1 rounded"
             style="cursor:pointer;"
             data-bs-toggle="modal"
             data-bs-target="<?= $cArV['modal']; ?>">
          <span class="text-muted small text-uppercase">Argentina Vespertina</span>
          <span class="h6 m-0 text-dark fw-bold"><?= number_format($totalArV, 2, '.', ','); ?></span>
        </div>
        <?php endif; ?>

      </div>
    </div>
  </div>
  <?php endforeach; ?>
</div>

<?php
// === Mapear por id_cifras para unificar SIN JUGAR ===
$mapSinEc  = [];
$mapSinAr  = [];
$mapSinArV = [];
foreach ($cifrasSinJugarEc as $c)  { $mapSinEc[$c['id_cifras']]  = $c; }
foreach ($cifrasSinJugarAr as $c)  { $mapSinAr[$c['id_cifras']]  = $c; }
foreach ($cifrasSinJugarArV as $c) { $mapSinArV[$c['id_cifras']] = $c; }
?>

<!-- TARJETAS UNIFICADAS: VENTAS SIN JUGAR -->
<div class="row mt-3 justify-content-center">
  <?php foreach ($mapSinEc as $id_cifras => $cEc): 
    $cAr  = $mapSinAr[$id_cifras]  ?? null;
    $cArV = $mapSinArV[$id_cifras] ?? null;

    $totalEc  = (float)($totalesSinJugarEc[$id_cifras]  ?? 0);
    $totalAr  = (float)($totalesSinJugarAr[$id_cifras]  ?? 0);
    $totalArV = (float)($totalesSinJugarArV[$id_cifras] ?? 0);

    $totalGeneralSin = $totalEc + $totalAr + $totalArV;
  ?>
  <div class="col-12 col-md-4 col-lg-4 mb-3">
    <div class="card card-hover border border-4 <?= $cEc['color'] ?>">
      <div class="d-flex align-items-center <?= $cEc['color'] ?> text-white p-2">
        <i class="fas fa-dollar-sign fa-2x me-2"></i>
        <div class="flex-grow-1">
          <div class="fw-bold text-uppercase">
            Ventas sin jugar - <?= htmlspecialchars($cEc['titulo'] ?? ('Cifras '.$id_cifras), ENT_QUOTES, 'UTF-8'); ?>
          </div>
          <div class="small text-white-50">Total (Ec + Ar Mat + Ar Vesp)</div>
        </div>
        <div class="ms-2 text-end">
          <div class="h4 m-0 fw-bold"><?= number_format($totalGeneralSin, 2, '.', ','); ?></div>
        </div>
      </div>
      <div class="bg-light p-2 rounded-bottom">

        <!-- ECUADOR -->
        <div class="d-flex justify-content-between align-items-center mb-2 px-2 py-1 rounded"
             style="cursor:pointer;"
             data-bs-toggle="modal"
             data-bs-target="<?= $cEc['modal']; ?>">
          <span class="text-muted small text-uppercase">Ecuador</span>
          <span class="h5 m-0 text-dark fw-bold"><?= number_format($totalEc, 2, '.', ','); ?></span>
        </div>

        <!-- ARGENTINA MATUTINA -->
        <?php if ($cAr): ?>
        <div class="d-flex justify-content-between align-items-center mb-2 px-2 py-1 rounded"
             style="cursor:pointer;"
             data-bs-toggle="modal"
             data-bs-target="<?= $cAr['modal']; ?>">
          <span class="text-muted small text-uppercase">Argentina Matutina</span>
          <span class="h6 m-0 text-dark fw-bold"><?= number_format($totalAr, 2, '.', ','); ?></span>
        </div>
        <?php endif; ?>

        <!-- ARGENTINA VESPERTINA -->
        <?php if ($cArV): ?>
        <div class="d-flex justify-content-between align-items-center px-2 py-1 rounded"
             style="cursor:pointer;"
             data-bs-toggle="modal"
             data-bs-target="<?= $cArV['modal']; ?>">
          <span class="text-muted small text-uppercase">Argentina Vespertina</span>
          <span class="h6 m-0 text-dark fw-bold"><?= number_format($totalArV, 2, '.', ','); ?></span>
        </div>
        <?php endif; ?>

      </div>
    </div>
  </div>
  <?php endforeach; ?>
</div>

<?php
// === Mapear por id_cifras para GANADORES PENDIENTES ===
$mapPendEc  = [];
$mapPendAr  = [];
$mapPendArV = [];
foreach ($cifrasPend   as $c) { $mapPendEc[$c['id_cifras']]  = $c; }
foreach ($cifrasPendAr as $c) { $mapPendAr[$c['id_cifras']]  = $c; }
foreach ($cifrasPendArV as $c){ $mapPendArV[$c['id_cifras']] = $c; }
?>

<!-- TARJETAS UNIFICADAS: GANADORES PENDIENTES -->
<div class="row mt-3 justify-content-center">
  <?php foreach ($mapPendEc as $id_cifras => $cEc): 
    $cAr  = $mapPendAr[$id_cifras]  ?? null;
    $cArV = $mapPendArV[$id_cifras] ?? null;

    $totalEc  = (float)($totalesPendEc[$id_cifras]  ?? 0);
    $totalAr  = (float)($totalesPendAr[$id_cifras]  ?? 0);
    $totalArV = (float)($totalesPendArV[$id_cifras] ?? 0);

    $totalGeneralPend = $totalEc + $totalAr + $totalArV;
  ?>
  <div class="col-12 col-md-4 col-lg-4 mb-3">
    <div class="card card-hover border border-4 <?= $cEc['color'] ?>">
      <div class="d-flex align-items-center <?= $cEc['color'] ?> text-white p-2">
        <i class="fas fa-dollar-sign fa-2x me-2"></i>
        <div class="flex-grow-1">
          <div class="fw-bold text-uppercase">
            pendientes - <?= htmlspecialchars($cEc['titulo'] ?? ('Cifras '.$id_cifras), ENT_QUOTES, 'UTF-8'); ?>
          </div>
          <div class="small text-white-50">Total (Ec + Ar Mat + Ar Vesp)</div>
        </div>
        <div class="ms-2 text-end">
          <div class="h4 m-0 fw-bold"><?= number_format($totalGeneralPend, 2, '.', ','); ?></div>
        </div>
      </div>
      <div class="bg-light p-2 rounded-bottom">
        <!-- ECUADOR -->
        <div class="d-flex justify-content-between align-items-center mb-2 px-2 py-1 rounded"
             style="cursor:pointer;"
             data-bs-toggle="modal"
             data-bs-target="<?= $cEc['modal']; ?>">
          <span class="text-muted small text-uppercase">Ecuador</span>
          <span class="h5 m-0 text-dark fw-bold"><?= number_format($totalEc, 2, '.', ','); ?></span>
        </div>

        <!-- ARGENTINA MATUTINA -->
        <?php if ($cAr): ?>
        <div class="d-flex justify-content-between align-items-center mb-2 px-2 py-1 rounded"
             style="cursor:pointer;"
             data-bs-toggle="modal"
             data-bs-target="<?= $cAr['modal']; ?>">
          <span class="text-muted small text-uppercase">Argentina Matutina</span>
          <span class="h6 m-0 text-dark fw-bold"><?= number_format($totalAr, 2, '.', ','); ?></span>
        </div>
        <?php endif; ?>

        <!-- ARGENTINA VESPERTINA -->
        <?php if ($cArV): ?>
        <div class="d-flex justify-content-between align-items-center px-2 py-1 rounded"
             style="cursor:pointer;"
             data-bs-toggle="modal"
             data-bs-target="<?= $cArV['modal']; ?>">
          <span class="text-muted small text-uppercase">Argentina Vespertina</span>
          <span class="h6 m-0 text-dark fw-bold"><?= number_format($totalArV, 2, '.', ','); ?></span>
        </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <?php endforeach; ?>
</div>


<?php
// === Mapear por id/categoría para unificar GANADORES PAGADOS ===
$mapPagEc  = $catsPagadosEc ?? [];
$mapPagAr  = $catsPagadosAr ?? [];
$mapPagArV = $catsPagadosArV ?? [];
?>

<!-- === TARJETAS UNIFICADAS: GANADORES PAGADOS (EC, AR MAT, AR VESP) === -->
<div class="row mt-3 justify-content-center">
  <?php foreach ($mapPagEc as $id => $infoEc): 
        // Buscar misma categoría/cifra en AR Matutina y Vespertina
        $infoAr  = $mapPagAr[$id]  ?? null;
        $infoArV = $mapPagArV[$id] ?? null;

        // Totales individuales
        $totalEc  = (float)($totalesPagadosEc[$id]  ?? 0);
        $totalAr  = (float)($totalesPagadosAr[$id]  ?? 0);
        $totalArV = (float)($totalesPagadosArV[$id] ?? 0);

        // TOTAL GENERAL = suma de las tres loterías
        $totalGeneralPag = $totalEc + $totalAr + $totalArV;
  ?>
    <div class="col-12 col-md-4 col-lg-4 mb-3">
      <div class="card card-hover border border-4 <?= $infoEc['color'] ?>">

        <!-- Cabecera de la tarjeta con TOTAL GENERAL -->
        <div class="d-flex align-items-center <?= $infoEc['color'] ?> text-white p-2">
          <i class="fas fa-dollar-sign fa-2x me-2"></i>
          <div class="flex-grow-1">
            <div class="fw-bold text-uppercase">
              pagados - <?= htmlspecialchars($infoEc['titulo'] ?? ('Cifras ' . $id), ENT_QUOTES, 'UTF-8'); ?>
            </div>
            <div class="small text-white-50">
              Total (Ec + Ar + Ar Vesp)
            </div>
          </div>
          <div class="ms-2 text-end">
            <div class="h4 m-0 fw-bold">
              <?= number_format($totalGeneralPag, 2, '.', ','); ?>
            </div>
          </div>
        </div>

        <!-- Cuerpo con los tres totales, cada uno con su modal -->
        <div class="bg-light p-2 rounded-bottom">

          <!-- ECUADOR -->
          <div class="d-flex justify-content-between align-items-center mb-2 px-2 py-1 rounded"
               style="cursor:pointer;"
               data-bs-toggle="modal"
               data-bs-target="<?= $infoEc['modal']; ?>">
            <span class="text-muted small text-uppercase">Ecuador</span>
            <span class="h5 m-0 text-dark fw-bold">
              <?= number_format($totalEc, 2, '.', ','); ?>
            </span>
          </div>

          <!-- ARGENTINA MATUTINA -->
          <?php if ($infoAr): ?>
          <div class="d-flex justify-content-between align-items-center mb-2 px-2 py-1 rounded"
               style="cursor:pointer;"
               data-bs-toggle="modal"
               data-bs-target="<?= $infoAr['modal']; ?>">
            <span class="text-muted small text-uppercase">Argentina Matutina</span>
            <span class="h6 m-0 text-dark fw-bold">
              <?= number_format($totalAr, 2, '.', ','); ?>
            </span>
          </div>
          <?php endif; ?>

          <!-- ARGENTINA VESPERTINA -->
          <?php if ($infoArV): ?>
          <div class="d-flex justify-content-between align-items-center px-2 py-1 rounded"
               style="cursor:pointer;"
               data-bs-toggle="modal"
               data-bs-target="<?= $infoArV['modal']; ?>">
            <span class="text-muted small text-uppercase">Argentina Vespertina</span>
            <span class="h6 m-0 text-dark fw-bold">
              <?= number_format($totalArV, 2, '.', ','); ?>
            </span>
          </div>
          <?php endif; ?>

        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<?php
// === Mapear por id/categoría para unificar GANADORES CADUCADOS ===
$mapCadEc  = $catsCad   ?? [];
$mapCadAr  = $catsCadAr ?? [];
$mapCadArV = $catsCadArV ?? [];
?>

<!-- === TARJETAS UNIFICADAS: GANADORES CADUCADOS (EC, AR MAT, AR VESP) === -->
<div class="row mt-3 justify-content-center">
  <?php foreach ($mapCadEc as $id => $infoEc): 
        // Buscar misma categoría/cifra en AR Matutina y Vespertina
        $infoAr  = $mapCadAr[$id]  ?? null;
        $infoArV = $mapCadArV[$id] ?? null;

        // Totales individuales
        $totalEc  = (float)($totalesCad[$id]      ?? 0);   // Ecuador
        $totalAr  = (float)($totalesCadAr[$id]    ?? 0);   // Argentina Matutina
        $totalArV = (float)($totalesCadArV[$id]   ?? 0);   // Argentina Vespertina

        // TOTAL GENERAL = suma de las tres loterías
        $totalGeneralCad = $totalEc + $totalAr + $totalArV;
  ?>
    <div class="col-12 col-md-4 col-lg-4 mb-3">
      <div class="card card-hover border border-4 <?= $infoEc['color'] ?>">

        <!-- Cabecera de la tarjeta con TOTAL GENERAL -->
        <div class="d-flex align-items-center <?= $infoEc['color'] ?> text-white p-2">
          <i class="fas fa-dollar-sign fa-2x me-2"></i>
          <div class="flex-grow-1">
            <div class="fw-bold text-uppercase">
              caducados - <?= htmlspecialchars($infoEc['titulo'] ?? ('Cifras ' . $id), ENT_QUOTES, 'UTF-8'); ?>
            </div>
            <div class="small text-white-50">
              Total Caducados (Ec + Ar Mat + Ar Vesp)
            </div>
          </div>
          <div class="ms-2 text-end">
            <div class="h4 m-0 fw-bold">
              <?= number_format($totalGeneralCad, 2, '.', ','); ?>
            </div>
          </div>
        </div>

        <!-- Cuerpo con los tres totales, cada uno con su modal -->
        <div class="bg-light p-2 rounded-bottom">

          <!-- ECUADOR -->
          <div class="d-flex justify-content-between align-items-center mb-2 px-2 py-1 rounded"
               style="cursor:pointer;"
               data-bs-toggle="modal"
               data-bs-target="<?= $infoEc['modal']; ?>">
            <span class="text-muted small text-uppercase">Ecuador</span>
            <span class="h5 m-0 text-dark fw-bold">
              <?= number_format($totalEc, 2, '.', ','); ?>
            </span>
          </div>

          <!-- ARGENTINA MATUTINA -->
          <?php if ($infoAr): ?>
          <div class="d-flex justify-content-between align-items-center mb-2 px-2 py-1 rounded"
               style="cursor:pointer;"
               data-bs-toggle="modal"
               data-bs-target="<?= $infoAr['modal']; ?>">
            <span class="text-muted small text-uppercase">Argentina Matutina</span>
            <span class="h6 m-0 text-dark fw-bold">
              <?= number_format($totalAr, 2, '.', ','); ?>
            </span>
          </div>
          <?php endif; ?>

          <!-- ARGENTINA VESPERTINA -->
          <?php if ($infoArV): ?>
          <div class="d-flex justify-content-between align-items-center px-2 py-1 rounded"
               style="cursor:pointer;"
               data-bs-toggle="modal"
               data-bs-target="<?= $infoArV['modal']; ?>">
            <span class="text-muted small text-uppercase">Argentina Vespertina</span>
            <span class="h6 m-0 text-dark fw-bold">
              <?= number_format($totalArV, 2, '.', ','); ?>
            </span>
          </div>
          <?php endif; ?>

        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>


  </div> <!-- /main-content -->

  <!-- JS Bootstrap y DataTables -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/js/bootstrap-select.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta2/dist/js/i18n/defaults-es_ES.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>

  <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

  <!-- Tus scripts de DataTables (ya existentes) -->
  <script src="../../resources/js/menu_hoy2c.js"></script>
  <script src="../../resources/js/menu_hoy2c_ar.js"></script>
  <script src="../../resources/js/menu_hoy2c_ar_v.js"></script>
  <script src="../../resources/js/menu_hoy3c.js"></script>
  <script src="../../resources/js/menu_hoy3c_ar.js"></script>
  <script src="../../resources/js/menu_hoy3c_ar_v.js"></script>
  <script src="../../resources/js/menu_hoy4c.js"></script>
  <script src="../../resources/js/menu_hoy4c_ar.js"></script>
  <script src="../../resources/js/menu_hoy4c_ar_v.js"></script>

  <script src="../../resources/js/menu_sinjugar2c.js"></script>
  <script src="../../resources/js/menu_sinjugar2c_ar.js"></script>
  <script src="../../resources/js/menu_sinjugar2c_ar_v.js"></script>
  <script src="../../resources/js/menu_sinjugar3c.js"></script>
  <script src="../../resources/js/menu_sinjugar3c_ar.js"></script>
  <script src="../../resources/js/menu_sinjugar3c_ar_v.js"></script>
  <script src="../../resources/js/menu_sinjugar4c.js"></script>
  <script src="../../resources/js/menu_sinjugar4c_ar.js"></script>
  <script src="../../resources/js/menu_sinjugar4c_ar_v.js"></script>

  <script src="../../resources/js/menu_pendiente2c.js"></script>
  <script src="../../resources/js/menu_pendiente2c_ar.js"></script>
  <script src="../../resources/js/menu_pendiente2c_ar_v.js"></script>
  <script src="../../resources/js/menu_pendiente3c.js"></script>
  <script src="../../resources/js/menu_pendiente3c_ar.js"></script>
  <script src="../../resources/js/menu_pendiente3c_ar_v.js"></script>
  <script src="../../resources/js/menu_pendiente4c.js"></script>
  <script src="../../resources/js/menu_pendiente4c_ar.js"></script>
  <script src="../../resources/js/menu_pendiente4c_ar_v.js"></script>

  <script src="../../resources/js/menu_pagado2c.js"></script>
  <script src="../../resources/js/menu_pagado2c_ar.js"></script>
  <script src="../../resources/js/menu_pagado2c_ar_v.js"></script>
  <script src="../../resources/js/menu_pagado3c.js"></script>
  <script src="../../resources/js/menu_pagado3c_ar.js"></script>
  <script src="../../resources/js/menu_pagado3c_ar_v.js"></script>
  <script src="../../resources/js/menu_pagado4c.js"></script>
  <script src="../../resources/js/menu_pagado4c_ar.js"></script>
  <script src="../../resources/js/menu_pagado4c_ar_v.js"></script>

  <script src="../../resources/js/menu_caducado2c.js"></script>
  <script src="../../resources/js/menu_caducado2c_ar.js"></script>
  <script src="../../resources/js/menu_caducado2c_ar_v.js"></script>
  <script src="../../resources/js/menu_caducado3c.js"></script>
  <script src="../../resources/js/menu_caducado3c_ar.js"></script>
  <script src="../../resources/js/menu_caducado3c_ar_v.js"></script>
  <script src="../../resources/js/menu_caducado4c.js"></script>
  <script src="../../resources/js/menu_caducado4c_ar.js"></script>
  <script src="../../resources/js/menu_caducado4c_ar_v.js"></script>

  <script>
    function cerrar() {
      Swal.fire({
        title: '¿Estás seguro?',
        text: '¿Deseas cerrar sesión?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sí, cerrar sesión',
        cancelButtonText: 'Cancelar',
      }).then((result) => {
        if (!result.isConfirmed) return;
        const loader = document.createElement('div');
        loader.className = 'loader';
        loader.textContent = 'Cerrando sesión...';
        document.body.appendChild(loader);

        fetch('../../controllers/usuario.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
          body: new URLSearchParams({ boton: 'cerrar' }),
        })
        .then((r) => { if (!r.ok) throw new Error('Error en la solicitud'); return r.text(); })
        .then(() => location.href = '../index.php')
        .catch((e) => Swal.fire('Error', e.message, 'error'))
        .finally(() => loader.remove());
      });
    }

    function toggleSidebar() {
      document.getElementById('sidebar').classList.toggle('show');
    }

    $(document).ready(function () {
      dayjs.locale('es');
      $('#fechaActual').text(dayjs().format('dddd, DD MMMM YYYY'));
      const tick = () => $('#horaActual').text(dayjs().format('h:mm A'));
      tick();
      setInterval(tick, 60 * 1000);
    });
  </script>

  <!-- MODALES -->

  <!-- Ventas 2c hoy nacional-->
  <div class="modal fade" id="ventasModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Total de ventas de dos cifras: <strong>
            <?php echo '$' . number_format((float)($totalesHoy[1] ?? 0), 2, '.', ','); ?>
          </strong></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body p-2">
          <div class="table-responsive">
            <table id="ticket_2c" class="table table-striped w-100 m-0">
              <thead>
                <tr class="text-center">
                  <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                  <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th><th>Acción</th>
                </tr>
              </thead><tbody></tbody><tfoot></tfoot>
            </table>
          </div>
        </div>
        <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
      </div>
    </div>
  </div>

 <!-- Ventas hoy 2 cifras - ARGENTINA MATITUNA-->
<div class="modal fade" id="ventasModalAr" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">
          Total de ventas de dos cifras (Argentina): 
          <strong>
            <?php echo '$' . number_format((float)($totalesHoyAr[1] ?? 0), 2, '.', ','); ?>
          </strong>
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body p-2">
        <div class="table-responsive">
          <table id="ticket_2c_ar" class="table table-striped w-100 m-0">
            <thead>
              <tr class="text-center">
                <th>Código</th>
                <th>Lotería</th>
                <th>Número</th>
                <th>Fecha Realizado</th>
                <th>Fecha Juega</th>
                <th>Valor</th>
                <th>Negocio</th>
                <th>Usuario</th>
                <th>Valor a pagar</th>
                <th>Acción</th>
              </tr>
            </thead>
            <tbody></tbody>
            <tfoot></tfoot>
          </table>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Ventas hoy 2 cifras - ARGENTINA VESPERTINA-->
<div class="modal fade" id="ventasModalArV" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">
          Total de ventas de dos cifras (Argentina): 
          <strong>
            <?php echo '$' . number_format((float)($totalesHoyArV[1] ?? 0), 2, '.', ','); ?>
          </strong>
        </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body p-2">
        <div class="table-responsive">
          <table id="ticket_2c_ar_v" class="table table-striped w-100 m-0">
            <thead>
              <tr class="text-center">
                <th>Código</th>
                <th>Lotería</th>
                <th>Número</th>
                <th>Fecha Realizado</th>
                <th>Fecha Juega</th>
                <th>Valor</th>
                <th>Negocio</th>
                <th>Usuario</th>
                <th>Valor a pagar</th>
                <th>Acción</th>
              </tr>
            </thead>
            <tbody></tbody>
            <tfoot></tfoot>
          </table>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Ventas 3c hoy nacional-->
 <div class="modal fade" id="ventasModal3d" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Total de ventas tres cifras: <strong>
            <?php echo '$' . number_format((float)($totalesHoy[2] ?? 0), 2, '.', ','); ?>
          </strong></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body p-2">
          <div class="table-responsive">
            <table id="ticket_3c" class="table table-striped w-100 m-0">
              <thead>
                <tr class="text-center">
                  <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                  <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th><th>Acción</th>
                </tr>
              </thead><tbody></tbody><tfoot></tfoot>
            </table>
          </div>
        </div>
        <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
      </div>
    </div>
  </div>

  <!-- Ventas hoy 3 cifras - ARGENTINA MATUTINA-->
    <div class="modal fade" id="ventasModal3dAr" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">
              Total de ventas tres cifras (Argentina): 
              <strong>
                <?php echo '$' . number_format((float)($totalesHoyAr[2] ?? 0), 2, '.', ','); ?>
              </strong>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body p-2">
            <div class="table-responsive">
              <table id="ticket_3c_ar" class="table table-striped w-100 m-0">
                <thead>
                  <tr class="text-center">
                    <th>Código</th>
                    <th>Lotería</th>
                    <th>Número</th>
                    <th>Fecha Realizado</th>
                    <th>Fecha Juega</th>
                    <th>Valor</th>
                    <th>Negocio</th>
                    <th>Usuario</th>
                    <th>Valor a pagar</th>
                    <th>Acción</th>
                  </tr>
                </thead>
                <tbody></tbody>
                <tfoot></tfoot>
              </table>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
          </div>
        </div>
      </div>
    </div>
	
	<!-- Ventas hoy 3 cifras - ARGENTINA VESPERTINA-->
    <div class="modal fade" id="ventasModal3dArV" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">
              Total de ventas tres cifras (Argentina): 
              <strong>
                <?php echo '$' . number_format((float)($totalesHoyArV[2] ?? 0), 2, '.', ','); ?>
              </strong>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body p-2">
            <div class="table-responsive">
              <table id="ticket_3c_ar_v" class="table table-striped w-100 m-0">
                <thead>
                  <tr class="text-center">
                    <th>Código</th>
                    <th>Lotería</th>
                    <th>Número</th>
                    <th>Fecha Realizado</th>
                    <th>Fecha Juega</th>
                    <th>Valor</th>
                    <th>Negocio</th>
                    <th>Usuario</th>
                    <th>Valor a pagar</th>
                    <th>Acción</th>
                  </tr>
                </thead>
                <tbody></tbody>
                <tfoot></tfoot>
              </table>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
          </div>
        </div>
      </div>
    </div>


    <!-- Ventas 4c hoy nacional-->
    <div class="modal fade" id="ventasModal4d" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Total de ventas cuatro cifras: <strong>
            <?php echo '$' . number_format((float)($totalesHoy[3] ?? 0), 2, '.', ','); ?>
          </strong></h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body p-2">
          <div class="table-responsive">
            <table id="ticket_4c" class="table table-striped w-100 m-0">
              <thead>
                <tr class="text-center">
                  <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                  <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th><th>Acción</th>
                </tr>
              </thead><tbody></tbody><tfoot></tfoot>
            </table>
          </div>
        </div>
        <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
      </div>
    </div>
  </div>

  <!-- Ventas hoy 4 cifras - ARGENTINA MATITUNA---->
    <div class="modal fade" id="ventasModal4dAr" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">
              Total de ventas cuatro cifras (Argentina): 
              <strong>
                <?php echo '$' . number_format((float)($totalesHoyAr[3] ?? 0), 2, '.', ','); ?>
              </strong>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body p-2">
            <div class="table-responsive">
              <table id="ticket_4c_ar" class="table table-striped w-100 m-0">
                <thead>
                  <tr class="text-center">
                    <th>Código</th>
                    <th>Lotería</th>
                    <th>Número</th>
                    <th>Fecha Realizado</th>
                    <th>Fecha Juega</th>
                    <th>Valor</th>
                    <th>Negocio</th>
                    <th>Usuario</th>
                    <th>Valor a pagar</th>
                    <th>Acción</th>
                  </tr>
                </thead>
                <tbody></tbody>
                <tfoot></tfoot>
              </table>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
          </div>
        </div>
      </div>
    </div>
	
	<!-- Ventas hoy 4 cifras - ARGENTINA VESPERTINA---->
    <div class="modal fade" id="ventasModal4dArV" tabindex="-1" aria-hidden="true">
      <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">
              Total de ventas cuatro cifras (Argentina): 
              <strong>
                <?php echo '$' . number_format((float)($totalesHoyArV[3] ?? 0), 2, '.', ','); ?>
              </strong>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body p-2">
            <div class="table-responsive">
              <table id="ticket_4c_ar_v" class="table table-striped w-100 m-0">
                <thead>
                  <tr class="text-center">
                    <th>Código</th>
                    <th>Lotería</th>
                    <th>Número</th>
                    <th>Fecha Realizado</th>
                    <th>Fecha Juega</th>
                    <th>Valor</th>
                    <th>Negocio</th>
                    <th>Usuario</th>
                    <th>Valor a pagar</th>
                    <th>Acción</th>
                  </tr>
                </thead>
                <tbody></tbody>
                <tfoot></tfoot>
              </table>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
          </div>
        </div>
      </div>
    </div>

    <!-- Sin jugar 2c nacional -->
      <div class="modal fade" id="ventassinModal2c" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Total de ventas sin jugar dos cifras: <strong>
                <?php echo '$' . number_format((float)($totalesSinJugarEc[1] ?? 0), 2, '.', ','); ?>
              </strong></h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-2">
              <div class="table-responsive">
                <table id="ticket_sin_2c" class="table table-striped w-100 m-0">
                  <thead>
                    <tr class="text-center">
                      <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                      <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                    </tr>
                  </thead><tbody></tbody><tfoot></tfoot>
                </table>
              </div>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
          </div>
        </div>
      </div>
      
      <!-- Sin jugar 2 cifras - ARGENTINA -->
        <div class="modal fade" id="ventassinModal2cAr" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">
                  Total de ventas sin jugar dos cifras (Argentina): 
                  <strong>
                    <?php echo '$' . number_format((float)($totalesSinJugarAr[1] ?? 0), 2, '.', ','); ?>
                  </strong>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body p-2">
                <div class="table-responsive">
                  <table id="ticket_sin_2c_ar" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Código</th>
                        <th>Lotería</th>
                        <th>Número</th>
                        <th>Fecha Realizado</th>
                        <th>Fecha Juega</th>
                        <th>Valor</th>
                        <th>Negocio</th>
                        <th>Usuario</th>
                        <th>Valor a pagar</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot></tfoot>
                  </table>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
              </div>
            </div>
          </div>
        </div>
        
        <!-- Sin jugar 3c nacional -->
      <div class="modal fade" id="ventassinModal3c" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Total de ventas sin jugar tres cifras: <strong>
                <?php echo '$' . number_format((float)($totalesSinJugarEc[2] ?? 0), 2, '.', ','); ?>
              </strong></h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-2">
              <div class="table-responsive">
                <table id="ticket_sin_3c" class="table table-striped w-100 m-0">
                  <thead>
                    <tr class="text-center">
                      <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                      <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                    </tr>
                  </thead><tbody></tbody><tfoot></tfoot>
                </table>
              </div>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
          </div>
        </div>
      </div>
      <!-- Sin jugar 2 cifras - ARGENTINA -->
        <div class="modal fade" id="ventassinModal2cAr" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">
                  Total de ventas sin jugar dos cifras (Argentina): 
                  <strong>
                    <?php echo '$' . number_format((float)($totalesSinJugarAr[1] ?? 0), 2, '.', ','); ?>
                  </strong>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body p-2">
                <div class="table-responsive">
                  <table id="ticket_sin_2c_ar" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Código</th>
                        <th>Lotería</th>
                        <th>Número</th>
                        <th>Fecha Realizado</th>
                        <th>Fecha Juega</th>
                        <th>Valor</th>
                        <th>Negocio</th>
                        <th>Usuario</th>
                        <th>Valor a pagar</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot></tfoot>
                  </table>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
              </div>
            </div>
          </div>
        </div>
        
		<!-- Sin jugar 2 cifras - ARGENTINA VESPERTINA-->
        <div class="modal fade" id="ventassinModal2cArV" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">
                  Total de ventas sin jugar dos cifras (Argentina): 
                  <strong>
                    <?php echo '$' . number_format((float)($totalesSinJugarArV[1] ?? 0), 2, '.', ','); ?>
                  </strong>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body p-2">
                <div class="table-responsive">
                  <table id="ticket_sin_2c_ar_v" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Código</th>
                        <th>Lotería</th>
                        <th>Número</th>
                        <th>Fecha Realizado</th>
                        <th>Fecha Juega</th>
                        <th>Valor</th>
                        <th>Negocio</th>
                        <th>Usuario</th>
                        <th>Valor a pagar</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot></tfoot>
                  </table>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
              </div>
            </div>
          </div>
        </div>
		
        <!-- Sin jugar 3c nacional -->
      <div class="modal fade" id="ventassinModal3c" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Total de ventas sin jugar tres cifras: <strong>
                <?php echo '$' . number_format((float)($totalesSinJugarEc[2] ?? 0), 2, '.', ','); ?>
              </strong></h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-2">
              <div class="table-responsive">
                <table id="ticket_sin_3c" class="table table-striped w-100 m-0">
                  <thead>
                    <tr class="text-center">
                      <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                      <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                    </tr>
                  </thead><tbody></tbody><tfoot></tfoot>
                </table>
              </div>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
          </div>
        </div>
      </div>
      <!-- Sin jugar 3 cifras - ARGENTINA -->
        <div class="modal fade" id="ventassinModal3cAr" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">
                  Total de ventas sin jugar tres cifras (Argentina): 
                  <strong>
                    <?php echo '$' . number_format((float)($totalesSinJugarAr[2] ?? 0), 2, '.', ','); ?>
                  </strong>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body p-2">
                <div class="table-responsive">
                  <table id="ticket_sin_3c_ar" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Código</th>
                        <th>Lotería</th>
                        <th>Número</th>
                        <th>Fecha Realizado</th>
                        <th>Fecha Juega</th>
                        <th>Valor</th>
                        <th>Negocio</th>
                        <th>Usuario</th>
                        <th>Valor a pagar</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot></tfoot>
                  </table>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
              </div>
            </div>
          </div>
        </div>
		
		<!-- Sin jugar 3 cifras - ARGENTINA VESPERTINA-->
        <div class="modal fade" id="ventassinModal3cArV" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">
                  Total de ventas sin jugar tres cifras (Argentina): 
                  <strong>
                    <?php echo '$' . number_format((float)($totalesSinJugarArV[2] ?? 0), 2, '.', ','); ?>
                  </strong>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body p-2">
                <div class="table-responsive">
                  <table id="ticket_sin_3c_ar_v" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Código</th>
                        <th>Lotería</th>
                        <th>Número</th>
                        <th>Fecha Realizado</th>
                        <th>Fecha Juega</th>
                        <th>Valor</th>
                        <th>Negocio</th>
                        <th>Usuario</th>
                        <th>Valor a pagar</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot></tfoot>
                  </table>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
              </div>
            </div>
          </div>
        </div>

        <!-- Sin jugar 4c nacional -->
      <div class="modal fade" id="ventassinModal4c" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-scrollable">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title">Total de ventas sin jugar cuatro cifras: <strong>
                <?php echo '$' . number_format((float)($totalesSinJugarEc[3] ?? 0), 2, '.', ','); ?>
              </strong></h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-2">
              <div class="table-responsive">
                <table id="ticket_sin_4c" class="table table-striped w-100 m-0">
                  <thead>
                    <tr class="text-center">
                      <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                      <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                    </tr>
                  </thead><tbody></tbody><tfoot></tfoot>
                </table>
              </div>
            </div>
            <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
          </div>
        </div>
      </div>
      
      <!-- Sin jugar 4 cifras - ARGENTINA -->
        <div class="modal fade" id="ventassinModal4cAr" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">
                  Total de ventas sin jugar cuatro cifras (Argentina): 
                  <strong>
                    <?php echo '$' . number_format((float)($totalesSinJugarAr[3] ?? 0), 2, '.', ','); ?>
                  </strong>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body p-2">
                <div class="table-responsive">
                  <table id="ticket_sin_4c_ar" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Código</th>
                        <th>Lotería</th>
                        <th>Número</th>
                        <th>Fecha Realizado</th>
                        <th>Fecha Juega</th>
                        <th>Valor</th>
                        <th>Negocio</th>
                        <th>Usuario</th>
                        <th>Valor a pagar</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot></tfoot>
                  </table>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
              </div>
            </div>
          </div>
        </div>
		
		<!-- Sin jugar 4 cifras - ARGENTINA VESPERTINA-->
        <div class="modal fade" id="ventassinModal4cArV" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-scrollable">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title">
                  Total de ventas sin jugar cuatro cifras (Argentina): 
                  <strong>
                    <?php echo '$' . number_format((float)($totalesSinJugarArV[3] ?? 0), 2, '.', ','); ?>
                  </strong>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              <div class="modal-body p-2">
                <div class="table-responsive">
                  <table id="ticket_sin_4c_ar_v" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Código</th>
                        <th>Lotería</th>
                        <th>Número</th>
                        <th>Fecha Realizado</th>
                        <th>Fecha Juega</th>
                        <th>Valor</th>
                        <th>Negocio</th>
                        <th>Usuario</th>
                        <th>Valor a pagar</th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot></tfoot>
                  </table>
                </div>
              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
              </div>
            </div>
          </div>
        </div>

        <!-- Pendientes 2c nacional-->
          <div class="modal fade" id="pendientesModal2c" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pendientes Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPendEc[1] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-2">
                  <div class="table-responsive">
                    <table id="ticket_pend_2c" class="table table-striped w-100 m-0">
                      <thead>
                        <tr class="text-center">
                          <th>Codigo</th>
						  <th>Loteria</th>
						  <th>Número</th>
						  <th>Fecha Realizado</th>
                          <th>Fecha Juega</th>
						  <th>Valor</th>
						  <th>Negocio</th>
						  <th>Usuario</th>
						  <th>Valor a pagar</th>
                        </tr>
                      </thead>
					  <tbody></tbody>
					  <tfoot></tfoot>
                    </table>
                  </div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>

          <!-- Pendientes 2c argentina Matutina-->
			<div class="modal fade" id="pendientesModal2cAr" tabindex="-1" aria-hidden="true">
			  <div class="modal-dialog modal-xl modal-dialog-scrollable">
				<div class="modal-content">
				  <div class="modal-header">
					<h5 class="modal-title">
					  Ventas Ganadoras Pendientes Últimos 8 días:
					  <strong>
						<?php echo '$' . number_format((float)($totalesPendAr[1] ?? 0), 2, '.', ','); ?>
					  </strong>
					</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
				  </div>

				  <div class="modal-body p-2">
					<div class="table-responsive">
					  <table id="ticket_pend_2c_ar" class="table table-striped w-100 m-0">
						<thead>
						  <tr class="text-center">
							<th>Codigo</th>
							<th>Loteria</th>
							<th>Número</th>
							<th>Fecha Realizado</th>
							<th>Fecha Juega</th>
							<th>Valor</th>
							<th>Negocio</th>
							<th>Usuario</th>
							<th>Valor a pagar</th>
						  </tr>
						</thead>
						<tbody></tbody>
						<tfoot>
						  <tr class="text-end">
							<th colspan="8">TOTAL</th>
							<th></th>
						  </tr>
						</tfoot>
					  </table>
					</div>
				  </div>

				  <div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
				  </div>
				</div>
			  </div>
			</div>
			
			<!-- Pendientes 2c argentina Vespertina-->
			<div class="modal fade" id="pendientesModal2cArV" tabindex="-1" aria-hidden="true">
			  <div class="modal-dialog modal-xl modal-dialog-scrollable">
				<div class="modal-content">
				  <div class="modal-header">
					<h5 class="modal-title">
					  Ventas Ganadoras Pendientes Últimos 8 días:
					  <strong>
						<?php echo '$' . number_format((float)($totalesPendArV[1] ?? 0), 2, '.', ','); ?>
					  </strong>
					</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
				  </div>

				  <div class="modal-body p-2">
					<div class="table-responsive">
					  <table id="ticket_pend_2c_ar_v" class="table table-striped w-100 m-0">
						<thead>
						  <tr class="text-center">
							<th>Codigo</th>
							<th>Loteria</th>
							<th>Número</th>
							<th>Fecha Realizado</th>
							<th>Fecha Juega</th>
							<th>Valor</th>
							<th>Negocio</th>
							<th>Usuario</th>
							<th>Valor a pagar</th>
						  </tr>
						</thead>
						<tbody></tbody>
						<tfoot>
						  <tr class="text-end">
							<th colspan="8">TOTAL</th>
							<th></th>
						  </tr>
						</tfoot>
					  </table>
					</div>
				  </div>

				  <div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
				  </div>
				</div>
			  </div>
			</div>

          <!-- Pendientes 3c nacional-->
           <div class="modal fade" id="pendientesModal3c" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pendientes Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPendEc[2] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-2">
                  <div class="table-responsive">
                    <table id="ticket_pend_3c" class="table table-striped w-100 m-0">
                      <thead>
                        <tr class="text-center">
                          <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                          <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                        </tr>
                      </thead><tbody></tbody><tfoot></tfoot>
                    </table>
                  </div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>

          <!-- Pendientes 3c Argentina Matutina-->
           <div class="modal fade" id="pendientesModal3cAr" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pendientes Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPendAr[2] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-2">
                  <div class="table-responsive">
                    <table id="ticket_pend_3c_ar" class="table table-striped w-100 m-0">
                      <thead>
                        <tr class="text-center">
                          <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                          <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                        </tr>
                      </thead><tbody></tbody><tfoot></tfoot>
                    </table>
                  </div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>
		  <!-- Pendientes 3c Argentina Vespertina-->
           <div class="modal fade" id="pendientesModal3cArV" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pendientes Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPendArV[2] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-2">
                  <div class="table-responsive">
                    <table id="ticket_pend_3c_ar_v" class="table table-striped w-100 m-0">
                      <thead>
                        <tr class="text-center">
                          <th>Codigo</th>
						  <th>Loteria</th>
						  <th>Número</th>
						  <th>Fecha Realizado</th>
                          <th>Fecha Juega</th>
						  <th>Valor</th>
						  <th>Negocio</th>
						  <th>Usuario</th>
						  <th>Valor a pagar</th>
                        </tr>
                      </thead>
					  <tbody></tbody>
					  <tfoot></tfoot>
                    </table>
                  </div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>

          <!-- Pendientes 4c nacional-->
          <div class="modal fade" id="pendientesModal4c" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pendientes Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPendEc[3] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-2">
                  <div class="table-responsive">
                    <table id="ticket_pend_4c" class="table table-striped w-100 m-0">
                      <thead>
                        <tr class="text-center">
                          <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                          <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                        </tr>
                      </thead><tbody></tbody><tfoot></tfoot>
                    </table>
                  </div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>

           <!-- Pendientes 4c argentina Matutina-->
          <div class="modal fade" id="pendientesModal4cAr" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pendientes Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPendAr[3] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-2">
                  <div class="table-responsive">
                    <table id="ticket_pend_4c_ar" class="table table-striped w-100 m-0">
                      <thead>
                        <tr class="text-center">
                          <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                          <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                        </tr>
                      </thead><tbody></tbody><tfoot></tfoot>
                    </table>
                  </div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>
		  
		   <!-- Pendientes 4c argentina Vespertina-->
          <div class="modal fade" id="pendientesModal4cArV" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pendientes Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPendArV[3] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-2">
                  <div class="table-responsive">
                    <table id="ticket_pend_4c_ar_v" class="table table-striped w-100 m-0">
                      <thead>
                        <tr class="text-center">
                          <th>Codigo</th>
						  <th>Loteria</th>
						  <th>Número</th>
						  <th>Fecha Realizado</th>
                          <th>Fecha Juega</th>
						  <th>Valor</th>
						  <th>Negocio</th>
						  <th>Usuario</th>
						  <th>Valor a pagar</th>
                        </tr>
                      </thead>
					  <tbody></tbody>
					  <tfoot></tfoot>
                    </table>
                  </div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>
          
          <!-- Pagados 2c ecuador-->
          <div class="modal fade" id="pagadoModal2c" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pagadas Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPagadosEc[1] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <table id="ticket_pagado_2c" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                        <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                      </tr>
                    </thead><tbody></tbody><tfoot></tfoot>
                  </table>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>

          <!-- Pagados 2c Argentina-->
          <div class="modal fade" id="pagadoModal2cAr" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pagadas Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPagadosAr[1] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <table id="ticket_pagado_2c_ar" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                        <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                      </tr>
                    </thead><tbody></tbody><tfoot></tfoot>
                  </table>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>
		  
		  <!-- Pagados 2c Argentina Vespertina-->
          <div class="modal fade" id="pagadoModal2cArV" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pagadas Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPagadosArV[1] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <table id="ticket_pagado_2c_ar_v" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                        <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                      </tr>
                    </thead><tbody></tbody><tfoot></tfoot>
                  </table>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>

          <!-- Pagados 3c ecuador-->
          <div class="modal fade" id="pagadoModal3c" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-scrollable">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Ventas Ganadoras Pagadas Últimos 8 días: <strong>
                    <?php echo '$' . number_format((float)($totalesPagadosEc[2] ?? 0), 2, '.', ','); ?>
                  </strong></h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                  <table id="ticket_pagado_3c" class="table table-striped w-100 m-0">
                    <thead>
                      <tr class="text-center">
                        <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                        <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                      </tr>
                    </thead><tbody></tbody><tfoot></tfoot>
                  </table>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
              </div>
            </div>
          </div>

          <!-- Pagados 3c Argentina Matutina-->
            <div class="modal fade" id="pagadoModal3cAr" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-xl modal-dialog-scrollable">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title">Ventas Ganadoras Pagadas Últimos 8 días: <strong>
                        <?php echo '$' . number_format((float)($totalesPagadosAr[2] ?? 0), 2, '.', ','); ?>
                      </strong></h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                      <table id="ticket_pagado_3c_ar" class="table table-striped w-100 m-0">
                        <thead>
                          <tr class="text-center">
                            <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                            <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                          </tr>
                        </thead><tbody></tbody><tfoot></tfoot>
                      </table>
                    </div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
                  </div>
                </div>
            </div>
			<!-- Pagados 3c Argentina Vespertina-->
            <div class="modal fade" id="pagadoModal3cArV" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-xl modal-dialog-scrollable">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title">Ventas Ganadoras Pagadas Últimos 8 días: <strong>
                        <?php echo '$' . number_format((float)($totalesPagadosArV[2] ?? 0), 2, '.', ','); ?>
                      </strong></h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                      <table id="ticket_pagado_3c_ar_v" class="table table-striped w-100 m-0">
                        <thead>
                          <tr class="text-center">
                            <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                            <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                          </tr>
                        </thead><tbody></tbody><tfoot></tfoot>
                      </table>
                    </div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
                  </div>
                </div>
            </div>
             <!-- Pagados 4c ecuador-->
				<!-- Pagados 4c Ecuador -->
			<div class="modal fade" id="pagadoModal4c" tabindex="-1" aria-hidden="true">
			  <div class="modal-dialog modal-xl modal-dialog-scrollable">
				<div class="modal-content">
				  <div class="modal-header">
					<h5 class="modal-title">
					  Ventas Ganadoras Pagadas Últimos 8 días: 
					  <strong>
						<?php echo '$' . number_format((float)($totalesPagadosEc[3] ?? 0), 2, '.', ','); ?>
					  </strong>
					</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
				  </div>
				  <div class="modal-body">
					<table id="ticket_pagado_4c" class="table table-striped w-100 m-0">
					  <thead>
						<tr class="text-center">
						  <th>Codigo</th>
						  <th>Loteria</th>
						  <th>Número</th>
						  <th>Fecha Realizado</th>
						  <th>Fecha Juega</th>
						  <th>Valor</th>
						  <th>Negocio</th>
						  <th>Usuario</th>
						  <th>Valor a pagar</th>
						</tr>
					  </thead>
					  <tbody></tbody>
					  <tfoot></tfoot>
					</table>
				  </div>
				  <div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
					  Cerrar
					</button>
				  </div>
				</div>
			  </div>
			</div>


          <!-- Pagados 4c Argentina Matutina-->
            <div class="modal fade" id="pagadoModal4cAr" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-xl modal-dialog-scrollable">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title">Ventas Ganadoras Pagadas Últimos 8 días: <strong>
                        <?php echo '$' . number_format((float)($totalesPagadosAr[2] ?? 0), 2, '.', ','); ?>
                      </strong></h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                      <table id="ticket_pagado_4c_ar" class="table table-striped w-100 m-0">
                        <thead>
                          <tr class="text-center">
                            <th>Codigo</th>
							<th>Loteria</th>
							<th>Número</th>
							<th>Fecha Realizado</th>
                            <th>Fecha Juega</th>
							<th>Valor</th>
							<th>Negocio</th>
							<th>Usuario</th>
							<th>Valor a pagar</th>
                          </tr>
                        </thead>
						<tbody></tbody>
						<tfoot></tfoot>
                      </table>
                    </div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
                  </div>
                </div>
            </div>
			
			<!-- Pagados 4c Argentina Vespertina-->
            <div class="modal fade" id="pagadoModal4cArV" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-xl modal-dialog-scrollable">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title">Ventas Ganadoras Pagadas Últimos 8 días: <strong>
                        <?php echo '$' . number_format((float)($totalesPagadosArV[2] ?? 0), 2, '.', ','); ?>
                      </strong></h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                      <table id="ticket_pagado_4c_ar_v" class="table table-striped w-100 m-0">
                        <thead>
                          <tr class="text-center">
                            <th>Codigo</th>
							<th>Loteria</th>
							<th>Número</th>
							<th>Fecha Realizado</th>
                            <th>Fecha Juega</th>
							<th>Valor</th>
							<th>Negocio</th>
							<th>Usuario</th>
							<th>Valor a pagar</th>
                          </tr>
                        </thead>
						<tbody></tbody>
						<tfoot></tfoot>
                      </table>
                    </div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
                  </div>
                </div>
            </div>

            <!-- Caducados 2c ecuador -->
              <div class="modal fade" id="caducadoModal2c" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-xl modal-dialog-scrollable">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title">Ventas Ganadoras Caducadas Entre 8 y 15 días: <strong>
                        <?php echo '$' . number_format((float)($totalesCad[1] ?? 0), 2, '.', ','); ?>
                      </strong></h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                      <table id="table_caducado_2c" class="table table-striped w-100 m-0">
                        <thead>
                          <tr class="text-center">
                            <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                            <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                          </tr>
                        </thead><tbody></tbody><tfoot></tfoot>
                      </table>
                    </div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
                  </div>
                </div>
              </div>

              <!-- Caducados 2c Argentina Matutina-->
                <div class="modal fade" id="caducadoModal2cAr" tabindex="-1" aria-hidden="true">
                  <div class="modal-dialog modal-xl modal-dialog-scrollable">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title">
                          Ventas Ganadoras Caducadas Entre 8 y 15 días:
                          <strong>
                            <?php echo '$' . number_format((float)($totalesCadAr[1] ?? 0), 2, '.', ','); ?>
                          </strong>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                      </div>
                      <div class="modal-body">
                        <table id="table_caducado_2c_ar" class="table table-striped w-100 m-0">
                          <thead>
                            <tr class="text-center">
                              <th>Codigo</th>
                              <th>Loteria</th>
                              <th>Número</th>
                              <th>Fecha Realizado</th>
                              <th>Fecha Juega</th>
                              <th>Valor</th>
                              <th>Negocio</th>
                              <th>Usuario</th>
                              <th>Valor a pagar</th>
                            </tr>
                          </thead>
                          <tbody></tbody>
                          <tfoot></tfoot>
                        </table>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                      </div>
                    </div>
                  </div>
                </div>
				<!-- Caducados 2c Argentina Vespertina-->
                <div class="modal fade" id="caducadoModal2cArV" tabindex="-1" aria-hidden="true">
                  <div class="modal-dialog modal-xl modal-dialog-scrollable">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title">
                          Ventas Ganadoras Caducadas Entre 8 y 15 días:
                          <strong>
                            <?php echo '$' . number_format((float)($totalesCadArV[1] ?? 0), 2, '.', ','); ?>
                          </strong>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                      </div>
                      <div class="modal-body">
                        <table id="table_caducado_2c_ar_v" class="table table-striped w-100 m-0">
                          <thead>
                            <tr class="text-center">
                              <th>Codigo</th>
                              <th>Loteria</th>
                              <th>Número</th>
                              <th>Fecha Realizado</th>
                              <th>Fecha Juega</th>
                              <th>Valor</th>
                              <th>Negocio</th>
                              <th>Usuario</th>
                              <th>Valor a pagar</th>
                            </tr>
                          </thead>
                          <tbody></tbody>
                          <tfoot></tfoot>
                        </table>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- Caducados 3c ecuador -->
              <div class="modal fade" id="caducadoModal3c" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-xl modal-dialog-scrollable">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title">Ventas Ganadoras Caducadas Entre 8 y 15 días: <strong>
                        <?php echo '$' . number_format((float)($totalesCad[1] ?? 0), 2, '.', ','); ?>
                      </strong></h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                      <table id="table_caducado_3c" class="table table-striped w-100 m-0">
                        <thead>
                          <tr class="text-center">
                            <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                            <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                          </tr>
                        </thead><tbody></tbody><tfoot></tfoot>
                      </table>
                    </div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
                  </div>
                </div>
              </div>

              <!-- Caducados 3c Argentina Matutina-->
                <div class="modal fade" id="caducadoModal3cAr" tabindex="-1" aria-hidden="true">
                  <div class="modal-dialog modal-xl modal-dialog-scrollable">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title">
                          Ventas Ganadoras Caducadas Entre 8 y 15 días:
                          <strong>
                            <?php echo '$' . number_format((float)($totalesCadAr[1] ?? 0), 2, '.', ','); ?>
                          </strong>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                      </div>
                      <div class="modal-body">
                        <table id="table_caducado_3c_ar" class="table table-striped w-100 m-0">
                          <thead>
                            <tr class="text-center">
                              <th>Codigo</th>
                              <th>Loteria</th>
                              <th>Número</th>
                              <th>Fecha Realizado</th>
                              <th>Fecha Juega</th>
                              <th>Valor</th>
                              <th>Negocio</th>
                              <th>Usuario</th>
                              <th>Valor a pagar</th>
                            </tr>
                          </thead>
                          <tbody></tbody>
                          <tfoot></tfoot>
                        </table>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                      </div>
                    </div>
                  </div>
                </div>
				<!-- Caducados 3c Argentina Vespertina-->
                <div class="modal fade" id="caducadoModal3cArV" tabindex="-1" aria-hidden="true">
                  <div class="modal-dialog modal-xl modal-dialog-scrollable">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title">
                          Ventas Ganadoras Caducadas Entre 8 y 15 días:
                          <strong>
                            <?php echo '$' . number_format((float)($totalesCadArV[1] ?? 0), 2, '.', ','); ?>
                          </strong>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                      </div>
                      <div class="modal-body">
                        <table id="table_caducado_3c_ar_v" class="table table-striped w-100 m-0">
                          <thead>
                            <tr class="text-center">
                              <th>Codigo</th>
                              <th>Loteria</th>
                              <th>Número</th>
                              <th>Fecha Realizado</th>
                              <th>Fecha Juega</th>
                              <th>Valor</th>
                              <th>Negocio</th>
                              <th>Usuario</th>
                              <th>Valor a pagar</th>
                            </tr>
                          </thead>
                          <tbody></tbody>
                          <tfoot></tfoot>
                        </table>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                      </div>
                    </div>
                  </div>
                </div>
				
                <!-- Caducados 4c ecuador -->
              <div class="modal fade" id="caducadoModal4c" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-xl modal-dialog-scrollable">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title">Ventas Ganadoras Caducadas Entre 8 y 15 días: <strong>
                        <?php echo '$' . number_format((float)($totalesCad[1] ?? 0), 2, '.', ','); ?>
                      </strong></h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                      <table id="table_caducado_4c" class="table table-striped w-100 m-0">
                        <thead>
                          <tr class="text-center">
                            <th>Codigo</th><th>Loteria</th><th>Número</th><th>Fecha Realizado</th>
                            <th>Fecha Juega</th><th>Valor</th><th>Negocio</th><th>Usuario</th><th>Valor a pagar</th>
                          </tr>
                        </thead><tbody></tbody><tfoot></tfoot>
                      </table>
                    </div>
                    <div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button></div>
                  </div>
                </div>
              </div>

              <!-- Caducados 4c Argentina Matutina-->
                <div class="modal fade" id="caducadoModal4cAr" tabindex="-1" aria-hidden="true">
                  <div class="modal-dialog modal-xl modal-dialog-scrollable">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title">
                          Ventas Ganadoras Caducadas Entre 8 y 15 días:
                          <strong>
                            <?php echo '$' . number_format((float)($totalesCadAr[1] ?? 0), 2, '.', ','); ?>
                          </strong>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                      </div>
                      <div class="modal-body">
                        <table id="table_caducado_4c_ar" class="table table-striped w-100 m-0">
                          <thead>
                            <tr class="text-center">
                              <th>Codigo</th>
                              <th>Loteria</th>
                              <th>Número</th>
                              <th>Fecha Realizado</th>
                              <th>Fecha Juega</th>
                              <th>Valor</th>
                              <th>Negocio</th>
                              <th>Usuario</th>
                              <th>Valor a pagar</th>
                            </tr>
                          </thead>
                          <tbody></tbody>
                          <tfoot></tfoot>
                        </table>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                      </div>
                    </div>
                  </div>
                </div>
				<!-- Caducados 4c Argentina Vespertina-->
                <div class="modal fade" id="caducadoModal4cArV" tabindex="-1" aria-hidden="true">
                  <div class="modal-dialog modal-xl modal-dialog-scrollable">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title">
                          Ventas Ganadoras Caducadas Entre 8 y 15 días:
                          <strong>
                            <?php echo '$' . number_format((float)($totalesCadArV[1] ?? 0), 2, '.', ','); ?>
                          </strong>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                      </div>
                      <div class="modal-body">
                        <table id="table_caducado_4c_ar_v" class="table table-striped w-100 m-0">
                          <thead>
                            <tr class="text-center">
                              <th>Codigo</th>
                              <th>Loteria</th>
                              <th>Número</th>
                              <th>Fecha Realizado</th>
                              <th>Fecha Juega</th>
                              <th>Valor</th>
                              <th>Negocio</th>
                              <th>Usuario</th>
                              <th>Valor a pagar</th>
                            </tr>
                          </thead>
                          <tbody></tbody>
                          <tfoot></tfoot>
                        </table>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                      </div>
                    </div>
                  </div>
                </div>

</body>
</html>
