<?php
include("conex.php");
session_start();

header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['idusuario'])) {
  echo json_encode(["error" => "Error: Sesión no iniciada."], JSON_UNESCAPED_UNICODE);
  exit();
}
$id_usuario = (int)$_SESSION['idusuario'];

if (!isset($conn) || !$conn) {
  echo json_encode(["error" => "Error: Sin conexión a BD."], JSON_UNESCAPED_UNICODE);
  exit();
}

mysqli_set_charset($conn, 'utf8mb4');

/* ===== INPUT ===== */
$fecha    = mysqli_real_escape_string($conn, $_POST["fecha"] ?? '');
$loterias = mysqli_real_escape_string($conn, $_POST["loterias"] ?? '0');
$key      = mysqli_real_escape_string($conn, $_POST["key"] ?? '');

if ($fecha === '' || $key === '') {
  echo json_encode(["error" => "Parámetros inválidos (fecha o key)."], JSON_UNESCAPED_UNICODE);
  exit();
}

$condLoteria = '';
if ($loterias !== '' && $loterias !== '0') {
  $condLoteria = " AND s.id_loteria = '" . $loterias . "' ";
}

/*
  ✅ CAMBIOS CLAVE:
  - Ya NO filtramos t.estado=2 (para que también salga estado=3).
  - Traemos el estado real del ticket (t.estado).
  - En el GROUP BY por premio devolvemos:
      MIN(estado_t) => si hay mezcla 2 y 3, mostrará 2 (pendiente).
  - Enviamos ids_pendientes (solo t.estado=2) para pagar SOLO esos.
*/
$sql = "
SELECT 
  bw.premio,
  COUNT(DISTINCT bw.idrifa) AS tickets,
  GROUP_CONCAT(DISTINCT bw.suerte_txt ORDER BY bw.suerte_g) AS suertes,

  -- ids separados por estado
  GROUP_CONCAT(DISTINCT CASE WHEN bw.estado_t = 2 THEN bw.idrifa END) AS ids_pendientes,
  GROUP_CONCAT(DISTINCT CASE WHEN bw.estado_t = 3 THEN bw.idrifa END) AS ids_pagados,

  -- para compatibilidad: todos los ids (pendientes + pagados)
  GROUP_CONCAT(DISTINCT bw.idrifa) AS ids,

  GROUP_CONCAT(DISTINCT bw.codigo ORDER BY bw.codigo) AS codigos,
  GROUP_CONCAT(DISTINCT bw.numero_ticket ORDER BY bw.numero_ticket) AS numeros,

  -- estado agrupado
  MIN(bw.estado_t) AS estado_t_grupo
FROM (
  SELECT
    t.idrifa,
    t.estado AS estado_t,
    s.suerte_g,
    ts.premio,
    su.suerte AS suerte_txt,
    t.codigo,
    LPAD(t.numero,
      CASE t.id_cifras
        WHEN 1 THEN 2
        WHEN 2 THEN 3
        WHEN 3 THEN 4
      END, '0') AS numero_ticket
  FROM tbr_sorteo AS s
  INNER JOIN tbr_ticket AS t
    ON  t.fecha = s.fecha_g
    AND s.id_loteria = t.id_loteria
    AND (
          (t.id_cifras = 1 AND LPAD(t.numero,2,'0') = RIGHT(s.numero_g,2))
       OR (t.id_cifras = 2 AND LPAD(t.numero,3,'0') = RIGHT(s.numero_g,3))
       OR (t.id_cifras = 3 AND LPAD(t.numero,4,'0') = RIGHT(s.numero_g,4))
    )
  INNER JOIN tbr_ticket_suerte AS ts ON ts.id_ticket = t.idrifa
  INNER JOIN tbr_suerte        AS su ON su.numero_s  = s.suerte_g
  WHERE t.condicion = 1
    AND t.estado IN (2,3)          -- ✅ pendientes y pagados
    AND s.activo = 1
    AND s.condicion = 1
    AND s.fecha_g = '$fecha'
    AND t.id_usuario = '$id_usuario'
    AND ts.id_suerte = s.suerte_g
    AND t.`key` = '$key'
    $condLoteria
) AS bw
GROUP BY bw.premio
ORDER BY bw.premio DESC;
";

$query = mysqli_query($conn, $sql);

if ($query && mysqli_num_rows($query) > 0) {
  $respuesta = [];
  while ($r = mysqli_fetch_assoc($query)) {

    $estadoGrupo = (int)($r['estado_t_grupo'] ?? 0);
    $txtEstado   = ($estadoGrupo === 3) ? 'Pagado' : 'Pendiente';

    $respuesta[] = [
      'idrifa'         => null,
      'codigo'         => (string)($r['codigos'] ?? '-'),
      'loteria'        => '-',
      'numero_ganador' => (string)($r['numeros'] ?? ''),
      'suerte_ga'      => (string)($r['suertes'] ?? ''),
      'premio'         => number_format((float)($r['premio'] ?? 0), 2, '.', ''),
      'estado'         => $txtEstado,
      'estado_t'       => $estadoGrupo,

      // ✅ claves nuevas
      'ids'            => (string)($r['ids'] ?? ''),
      'ids_pendientes' => (string)($r['ids_pendientes'] ?? ''),
      'ids_pagados'    => (string)($r['ids_pagados'] ?? '')
    ];
  }
} else {
  $respuesta = ['error' => 'Esta vez tu ticket no tiene premio.'];
}

echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);
