<?php
session_start();
include("conex.php");

$idusuario = $_SESSION['idusuario'];
$categoria = $_POST['categoria'];
$codigo = $_POST['codigo'];
$nombre = $_POST['nombre'];
$stock_m = $_POST['stock_m'];
$condicion = 1;
$actividad = "NUEVA DE PRODUCTO";

$my_ip = $_SERVER["REMOTE_ADDR"]; 
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d'); // Formato estándar de fecha SQL
$time_actual = date('H:i:s');

// Comprobación si el producto ya existe
$stmt = $conn->prepare("SELECT p.codigo, p.nombre 
                        FROM tbi_producto AS p
                        WHERE p.condicion = 1 AND p.codigo = ? AND p.nombre = ?");
$stmt->bind_param("is", $codigo, $nombre);
$stmt->execute();
$result = $stmt->get_result();

if ($result->fetch_array()) {
    echo "Este código y producto ya se encuentran registrados.";
} else {
    // Insertar el producto
    $stmt_insert = $conn->prepare("INSERT INTO tbi_producto (codigo, nombre, stock_minimo, id_categoria, condicion) 
                                   VALUES (?, ?, ?, ?, ?)");
    $stmt_insert->bind_param("ssiii", $codigo, $nombre, $stock_m, $categoria, $condicion);
    
    if ($stmt_insert->execute()) {
        // Obtener el ID del último producto insertado
        $id_producto = $conn->insert_id;

        // Insertar en el historial
        $stmt_audit = $conn->prepare("INSERT INTO tbi_historial (fecha, hora, ip, detalle, id_producto, id_usuario)
                                      VALUES (?, ?, ?, ?, ?, ?)");
        $stmt_audit->bind_param("ssssii", $fecha_actual, $time_actual, $my_ip, $actividad, $id_producto, $idusuario);
        $stmt_audit->execute();

        //echo "Producto registrado y auditado correctamente.";
    } else {
        echo "Error al registrar el producto.";
    }
}

// Cerrar las consultas preparadas
$stmt->close();
if (isset($stmt_insert)) $stmt_insert->close();
if (isset($stmt_audit)) $stmt_audit->close();
$conn->close();
?>
