<?php
include("conex.php");

header('Content-Type: application/json'); // Asegura que la respuesta sea JSON

if (isset($_POST['idloteria'])) {
    $idloteria = $_POST['idloteria'];

    // Verificar la conexión
    if ($conn->connect_error) {
        echo json_encode(['success' => false, 'message' => 'Error de conexión con la base de datos']);
        exit;
    }

    // Actualizar la condición a 0 (deshabilitar)
    $sql = "UPDATE tbr_loteria SET condicion = 0 WHERE idloteria = ?";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Error en la preparación de la consulta']);
        exit;
    }

    $stmt->bind_param('i', $idloteria);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'No se pudo eliminar o la rifa no existe']);
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'No se proporcionó el ID de la rifa']);
}

$conn->close();
?>
