<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de gestion...</title>
    <link rel="shortcut icon" href="../resources/img/crud.ico">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f6f9;
            padding-top: 90px;
            padding-bottom: 40px;
        }

        #login-box {
            max-width: 400px;
            margin: auto;
            box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.2);
            border-radius: 8px;
            background-color: #fff;
            padding: 2rem;
        }

        .btn-primary {
            background-color: #0d6efd;
            border: none;
        }

        .btn-primary:hover {
            background-color: #0b5ed7;
        }

        .form-control {
            border-radius: 0.375rem;
        }

        .alert {
            display: none;
        }

        footer {
            text-align: center;
            margin-top: 20px;
            color: #6c757d;
        }

        .input-group-text {
            background-color: #e9ecef;
        }

        .toggle-password {
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <div id="login-box" class="text-center">
		
		<h3 class="card-title text-center mb-4"><i class="fas fa-tachometer-alt"></i> GESTIÓN</h3>
        <p class="text-center text-muted">Inicia sesión para continuar...</p>

        <div class="alert alert-danger" id="error-msg" role="alert">
            <i class="fas fa-exclamation-circle"></i> Usuario o contraseña incorrectos.
        </div>
        <!-- Formulario de login -->
        <form action="../views/menu.html" method="post" name="form" id="login-form" class="form-signin">
		
            <div class="mb-3 input-group">
                <span class="input-group-text"><i class="fas fa-user"></i></span>
                <input type="text" id="usuario" class="form-control" placeholder="Usuario" required aria-label="Usuario">
            </div>

            <div class="mb-3 input-group">
                <span class="input-group-text"><i class="fas fa-lock"></i></span>
                <input type="password" id="pass" class="form-control" placeholder="Contraseña" required aria-label="Contraseña">
                <span class="input-group-text toggle-password"><i class="fas fa-eye-slash"></i></span>
            </div>

            <button class="btn btn-primary w-100" type="button" onclick="confirmar();">Iniciar sesión</button>
			 
        </form>       
    </div>
	<footer>
		<small>&copy; 2025 Sistema de Gestión Digital</small>
	</footer>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        document.onkeydown = function(evt) {
            var keyCode = evt ? (evt.which ? evt.which : evt.keyCode) : event.keyCode;
            if (keyCode == 13) {
                confirmar();
            }
        };

        function confirmar() {
            var usuario = $('#usuario').val().trim();
            var pass = $('#pass').val().trim();

            // Limpiar los mensajes de error antes de verificar
            $('#error').hide();
            $('#error2').hide();

            // Verificar que los campos no estén vacíos
            if (usuario === '' || pass === '') {
                $('#error-msg').text('Por favor, completa todos los campos.').show();
                return;
            }

            // Enviar la solicitud AJAX
            $.ajax({
                url: '../controllers/usuario.php',
                type: 'POST',
                data: { usuario: usuario, pass: pass, boton: 'ingresar' },
                beforeSend: function() {
                    $('.btn-login').attr('disabled', true).text('Iniciando...');
                }
            }).done(function(resp) {
                $('.btn-login').attr('disabled', false).text('Iniciar sesión');
                
                if (resp == 0) {
                    // Si la respuesta es 0, redirigir al menú
                    window.location.href = '../views/pages/ventas.php';
                }  else {
                    // Si hay otro tipo de respuesta, mostrar mensaje genérico de error
                    $('#error-msg').text("Usuario o Clave incorrecta. Intente nuevamente.").show();
                }
            }).fail(function() {
                // Manejo de error si la solicitud AJAX falla
                $('#error-msg').text("Hubo un error al procesar la solicitud. Intente nuevamente.").show();
            });
        }
		// Mostrar/ocultar contraseña
        $('.toggle-password').on('click', function () {
            var input = $('#pass');
            var icon = $(this).find('i');

            if (input.attr('type') === 'password') {
                input.attr('type', 'text');
                icon.removeClass('fa-eye-slash').addClass('fa-eye');
            } else {
                input.attr('type', 'password');
                icon.removeClass('fa-eye').addClass('fa-eye-slash');
            }
        });
    </script>
</body>
</html>
