$(document).ready(function () {
  var table = $("#usuar").DataTable({
    deferRender: true,
    paging: true,               // Activa la paginación (cámbialo a false si no la quieres)
    lengthChange: false,        // Oculta selector "mostrar N"
    searching: true,            // Habilita búsqueda
    autoWidth: true,
    pagingType: "full_numbers",
    ajax: {
      url: "funcion_usuarios.php", // Cambia si tu endpoint se llama distinto (p.ej. usuarios_list.php)
      type: "POST",
      dataSrc: "data"
    },
    columns: [
      { data: "usuario", className: "text-center" },
      { data: "sucursal", className: "text-center" },
      { data: "cupo", className: "text-end" },
      { data: "cupo3", className: "text-end" },
      { data: "cupo4", className: "text-end" },
      { data: "hora_i_anulacion", className: "text-center" },
      { data: "hora_f_anulacion", className: "text-center" },      
      { data: "activo", className: "text-end" },
	  { data: "ip", className: "text-center" },     // ← corregido
      { data: "accion", className: "text-center" }
    ],
    columnDefs: [
      // Columnas con HTML (no deben ordenar)
      { targets: [2, 3, 4, 8, 9], orderable: false, searchable: false }
    ],
    language: {
      processing: "Procesando...",
      lengthMenu: 'Mostrar _MENU_ registros',
      zeroRecords: "No se encontraron resultados",
      emptyTable: "Ningún dato disponible en esta tabla",
      info: "Mostrando del (_START_ al _END_) de un total de _TOTAL_ registros",
      infoEmpty: "Mostrando del 0 al 0 de un total de 0 registros",
      infoFiltered: "(filtrado de un total de _MAX_ registros)",
      search: "Buscar:",
      loadingRecords: "Por favor espere - cargando...",
      paginate: { first: "Primero", last: "Último", next: "Siguiente", previous: "Anterior" },
      aria: {
        sortAscending: ": Activar para ordenar la columna de manera ascendente",
        sortDescending: ": Activar para ordenar la columna de manera descendente"
      }
    },
    initComplete: function () {
      // Mover y estilizar el buscador cuando todo está listo
      $(".dataTables_filter").css({ float: "right", paddingRight: "10px" });
      $(".dataTables_filter input").css({
        width: "250px",
        display: "inline-block",
        padding: "5px",
        fontSize: "14px",
        textAlign: "right"
      });
    }
  });

  // Auto-actualización sin perder la página actual
  setInterval(function () {
    table.ajax.reload(null, false);
  }, 30000);
});
