$(document).ready(function() {               
    var table = $("#ticket3").DataTable({    
        "bAutoWidth": true,    
        "bDeferRender": true, // Habilitar defer render (puede mejorar el rendimiento con tablas grandes)
        "paging": false,      // Quita la paginación
        "bLengthChange": false, // Oculta el selector de cantidad de registros
        "bFilter": false,     // Oculta el campo de búsqueda
        "ajax": {
            "url": "funcion_ticket3.php",
            "type": "POST"
        },            

        "columns": [
            {"data": "loteria"},
            {"data": "fecha"},            
            {"data": "numero"},                    
            {"data": "valor"},                                 
            {"data": "accion"}
        ],
        
        "oLanguage": {
            "sProcessing": "Procesando...",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 de 0 registros",
            "sInfoFiltered": "(filtrado de _MAX_ registros)",
            "sLoadingRecords": "Por favor espere - cargando..."
        },

        "drawCallback": function(settings) {
            var api = this.api();
            
            // Función para convertir los valores a números
            var intVal = function(i) {
                return typeof i === "string"
                    ? parseFloat(i.replace(/[\$,]/g, "")) || 0
                    : typeof i === "number"
                    ? i
                    : 0;
            };

            // Total de todas las páginas
            var total = api
                .column(3) // Columna de valores
                .data()
                .reduce((a, b) => intVal(a) + intVal(b), 0);

            // Total solo de la página actual
            var pageTotal = api
                .column(3, { page: "current" })
                .data()
                .reduce((a, b) => intVal(a) + intVal(b), 0);

            // Insertar los valores en el footer
            $(api.column(3).footer()).html(
                "Total: $" + pageTotal.toFixed(2)
            );
        }
    });
});
