// resources/js/menu_sinjugar2c_ar.js
$(document).ready(function () {
  var table = $("#ticket_sin_2c_ar_v").DataTable({
    bDeferRender: true,      // Mejor rendimiento
    paging: false,           // Sin paginación
    bLengthChange: false,    // Sin selector de cantidad
    bFilter: true,           // Filtro/búsqueda
    ajax: {
      url: "funcion_sinjugar2c_ar_v.php",
      type: "POST",
      dataSrc: "data"
    },
    columns: [
      { data: "codigo" },
      { data: "loteria" },
      { data: "numero" },
      { data: "fechar" },
      { data: "fechaj" },
      { data: "valor" },
      { data: "negocio" },
      { data: "usuario" },
      { data: "pagar" }
    ],
    language: {
      processing: "Procesando...",
      zeroRecords: "No se encontraron resultados",
      emptyTable: "Ningún dato disponible en esta tabla",
      info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
      infoEmpty: "Mostrando 0 de 0 registros",
      infoFiltered: "(filtrado de _MAX_ registros totales)",
      loadingRecords: "Por favor espere - cargando...",
      search: "Buscar:",
      paginate: {
        first: "Primero",
        last: "Último",
        next: "Siguiente",
        previous: "Anterior"
      }
    }
  });

  // Ajustar tamaño de la caja de búsqueda
  $(".dataTables_filter input").css({
    width: "250px",
    display: "inline-block",
    padding: "6px",
    "font-size": "14px"
  });

  // Recarga automática cada 30s (si quieres)
  setInterval(function () {
    table.ajax.reload(null, false);
  }, 30000);
});
