$(document).ready(function () {
    var table = $("#ticket_hoy").DataTable({
        bDeferRender: true,
        paging: false,
        bLengthChange: false,
        bFilter: false,
        searching: true,
        order: [[1, "asc"]],
        ajax: {
            url: "funcion_r_up_usu4.php",
            type: "POST",
            data: function (d) {
                d.fecha_inicio = $("#fecha_inicio").val();
                d.fecha_fin = $("#fecha_fin").val();
            },
            dataSrc: function (json) {
                $("#totalGlobalVendido").text("$" + json.totales.total_vendido);
                $("#totalGlobalPremio").text("$" + json.totales.total_premio);
                $("#totalGlobalUtilidad").text("$" + json.totales.total_utilidad);
                return json.data;
            }
        },
        columns: [
            { data: "cifras", className: "text-end" },
            { data: "fecha", className: "text-end" },
            { data: "sucursal", className: "text-center" },
            { data: "usuario", className: "text-center" },
            { data: "vendido", className: "text-end" },
            { data: "premio", className: "text-end" },
            { data: "saldo", className: "text-end" }
        ],
        language: {
            processing: "Procesando...",
            zeroRecords: "No se encontraron resultados",
            emptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
            infoEmpty: "Mostrando 0 a 0 de 0 registros",
            infoFiltered: "(filtrado de _MAX_ registros)",
            loadingRecords: "Por favor espere - cargando...",
            search: "Buscar:",
            paginate: {
                first: "Primero",
                last: "Último",
                next: "Siguiente",
                previous: "Anterior"
            }
        },
        dom: '<"d-flex justify-content-between align-items-center mb-2" <"btn-container"B> <"search-container"f>>rtip',
        buttons: [
            {
                extend: "excelHtml5",
                text: '<i class="fa-solid fa-file-excel"></i>',
                className: "btn btn-success",
                exportOptions: { columns: ":visible" }
            },
            {
                extend: "pdfHtml5",
                text: '<i class="fa-solid fa-file-pdf"></i>',
                className: "btn btn-danger",
                orientation: "landscape",
                pageSize: "A4",
                exportOptions: { columns: ":visible" }
            }
        ],
        footerCallback: function (row, data, start, end, display) {
            let totalVendido = 0;
            let totalPremio = 0;
            let totalSaldo = 0;

            data.forEach(item => {
                totalVendido += parseFloat(item.vendido) || 0;
                totalPremio += parseFloat(item.premio) || 0;
                totalSaldo += parseFloat(item.saldo) || 0;
            });

            $("#ticket_hoy tfoot th:nth-child(5)").html('$' + totalVendido.toFixed(2));
            $("#ticket_hoy tfoot th:nth-child(6)").html('$' + totalPremio.toFixed(2));
            $("#ticket_hoy tfoot th:nth-child(7)").html('$' + totalSaldo.toFixed(2));
        }
    });

    // 🔁 Recargar automáticamente al cambiar fechas
    $("#fecha_inicio, #fecha_fin").on("change", function () {
        table.ajax.reload();
    });
});
