$(document).ready(function() {
    var table = $("#ticket_hoy").DataTable({
        "bDeferRender": true,
        "paging": false,
        "bLengthChange": false,
        "bFilter": true,
        "order": [[1, "asc"]],
        "ajax": {
            "url": "funcion_r_gana.php",
            "type": "POST",
            "data": function(d) {
                d.sucursal = $("#sucursal").val();
                d.usuario_s = $("#usuario_s").val();
                d.fecha_s = $("#fecha_s").val();
                console.log("Fecha enviada al servidor:", d.fecha_s);
            },
            "dataSrc": function(json) {
                console.log("Respuesta del servidor:", json);

                // Verificar si los datos esperados existen
                if (json.total && json.totalp) {
                    $("#total-value").text("$" + json.total);
                    $("#total-pagar").text("$" + json.totalp);
                } else {
                    console.error("Error: Faltan los totales en la respuesta del servidor.");
                }

                return json.data;
            }
        },
        "columns": [
            {"data": "cifras", className: "text-center"},
            {"data": "codigo", className: "text-center"},
            {"data": "key", className: "text-center"},
            {"data": "loteria", className: "text-end"},
            {"data": "suerte", className: "text-end"},
            {"data": "numero", className: "text-end"},
            {"data": "valor", className: "text-end"},
            {"data": "pagar", className: "text-end"},
            {"data": "negocio", className: "text-center"},
            {"data": "usuario", className: "text-center"},
            {"data": "tope1", className: "text-end"},
            {"data": "tope2", className: "text-end"},
            {"data": "estado", className: "text-end"}
        ],
        "language": {
            "processing": "Procesando...",
            "zeroRecords": "No se encontraron resultados",
            "emptyTable": "Ningún dato disponible en esta tabla",
            "info": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "infoEmpty": "Mostrando 0 de 0 registros",
            "infoFiltered": "(filtrado de _MAX_ registros)",
            "loadingRecords": "Cargando...",
            "search": "Buscar:",  
            "paginate": {
                "first": "Primero",
                "last": "Último",
                "next": "Siguiente",
                "previous": "Anterior"
            }
        },
		"dom": '<"d-flex justify-content-between" <"btn-container"B> <"search-container"f>>rtip',
        "buttons": [
    {
        extend: "excelHtml5",
        text: '<i class="fa-solid fa-file-excel"></i>',
        className: "btn btn-success",  // Verde para Excel
        titleAttr: "Exportar a Excel",
        exportOptions: { columns: ":visible" }
    },
    {
        extend: "pdfHtml5",
        text: '<i class="fa-solid fa-file-pdf"></i>',
        className: "btn btn-danger",  // Rojo para PDF
        titleAttr: "Exportar a PDF",
        orientation: "landscape",
        pageSize: "A4",
        exportOptions: { columns: ":visible" }
    }
],
        "drawCallback": function(settings) {
            var api = this.api();

            // Función para convertir los valores a números
            var intVal = function(i) {
                return typeof i === "string"
                    ? parseFloat(i.replace(/[\$,]/g, "")) || 0
                    : typeof i === "number"
                    ? i
                    : 0;
            };

            // Total de las columnas "valor", "pagar", "tope1", "tope2"
            var totalValor = api.column(6).data().reduce(function(a, b) {
                return intVal(a) + intVal(b);
            }, 0);
            var totalPagar = api.column(7).data().reduce(function(a, b) {
                return intVal(a) + intVal(b);
            }, 0);
            var totalTope1 = api.column(10).data().reduce(function(a, b) {
                return intVal(a) + intVal(b);
            }, 0);
            var totalTope2 = api.column(11).data().reduce(function(a, b) {
                return intVal(a) + intVal(b);
            }, 0);

            // Mostrar los totales en el pie de página
            $(api.column(6).footer()).html(totalValor.toFixed(2));
            $(api.column(7).footer()).html(totalPagar.toFixed(2));
            $(api.column(10).footer()).html(totalTope1.toFixed(2));
            $(api.column(11).footer()).html(totalTope2.toFixed(2));
        }
    });

    // Recargar la tabla al cambiar usuario, sucursal o fecha
    $("#usuario_s, #sucursal, #fecha_s").change(function() {
        console.log("Actualizando tabla con fecha:", $("#fecha_s").val());
        table.ajax.reload();
    });
});
