$(document).ready(function() {
    var table = $("#ticket_hoy").DataTable({
        "bDeferRender": true,
        "paging": false,
        "bLengthChange": false,
        "bFilter": false,
        "order": [[1, "asc"]],
        "ajax": {
            "url": "funcion_r_fecha.php",
            "type": "POST"
        },
        "columns": [
			{"data": "cifras", className: "text-center"},
            {"data": "sucursal", className: "text-center"},
            {"data": "usuario", className: "text-center"},
            {"data": "fechai", className: "text-end"},
            {"data": "fechaj", className: "text-end"},
            {"data": "vendido", className: "text-end"},            
            {"data": "ganado", className: "text-end"}
           
           
        ],
        "language": {
            "zeroRecords": "No se encontraron resultados",
            "emptyTable": "Ningún dato disponible",
            "info": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "loadingRecords": "Cargando..."
        },
		"dom": '<"d-flex justify-content-between" <"btn-container"B> <"search-container"f>>rtip',
        "buttons": [
    {
        extend: "excelHtml5",
        text: '<i class="fa-solid fa-file-excel"></i>',
        className: "btn btn-success",  // Verde para Excel
        titleAttr: "Exportar a Excel",
        exportOptions: { columns: ":visible" }
    },
    {
        extend: "pdfHtml5",
        text: '<i class="fa-solid fa-file-pdf"></i>',
        className: "btn btn-danger",  // Rojo para PDF
        titleAttr: "Exportar a PDF",
        orientation: "landscape",
        pageSize: "A4",
        exportOptions: { columns: ":visible" }
    }
],
        "footerCallback": function (row, data, start, end, display) {
            var totalVendido = 0;
            var totalGanado = 0;
            var totalPagado = 0;
            var totalNoCobrado = 0;

            // Recorrer las filas para sumar los valores de cada columna
            data.forEach(function (item) {
                totalVendido += parseFloat(item.vendido) || 0;
                totalGanado += parseFloat(item.ganado) || 0;
                
            });

            // Actualizar los valores en el pie de página (footer)
            $("#ticket_hoy tfoot th:nth-child(6)").html('$' + totalVendido.toFixed(2));  // Columna "ventido"
            $("#ticket_hoy tfoot th:nth-child(7)").html('$' + totalGanado.toFixed(2));   // Columna "ganado"
          
        }
    });

    // Recargar tabla al cambiar usuario, sucursal o fecha
    $("#usuario_s, #sucursal, #fecha_i, #fecha_f").change(function() {
        if (!$("#fecha_i").val() || !$("#fecha_f").val()) {
            console.warn("Las fechas deben estar completas antes de actualizar la tabla.");
            return;
        }

        let params = {
            usuario: $("#usuario_s").val(),
            sucursal: $("#sucursal").val(),
            fecha_i: $("#fecha_i").val(),
            fecha_f: $("#fecha_f").val()
        };

        console.log("Actualizando tabla con:", params);

        // Recargar la tabla con los nuevos parámetros
        table.ajax.url("funcion_r_fecha.php?" + $.param(params)).load();
    });
});
