$(document).ready(function() {
    const table = $("#ticket_hoy").DataTable({
        paging: false,
        lengthChange: false,
        searching: true,
        order: [[1, "asc"]],
        ajax: {
            url: "funcion_r_cadu.php",
            type: "POST",
            data: function(d) {
                d.sucursal     = $("#sucursal").val();
                d.usuario_s    = $("#usuario_s").val();
                d.fecha_inicio = $("#fecha_inicio").val();
                d.fecha_fin    = $("#fecha_fin").val();
            },
            dataSrc: function(json) {
                $("#total-value").text("$" + json.total);
                $("#total-pagar").text("$" + json.totalp);
                return json.data;
            }
        },
        columns: [
            { data: "cifras", className: "text-center" },
            { data: "codigo", className: "text-center" },
            { data: "key", className: "text-center" },
            { data: "fecha", className: "text-end" },
            { data: "loteria", className: "text-end" },
            { data: "suerte", className: "text-end" },
            { data: "numero", className: "text-end" },
            { data: "valor", className: "text-end" },
            { data: "pagar", className: "text-end" },
            { data: "negocio", className: "text-center" },
            { data: "usuario", className: "text-center" },
            { data: "tope1", className: "text-end" },
            { data: "tope2", className: "text-end" },
            { data: "estado", className: "text-end" }
        ],
        dom: '<"d-flex justify-content-between" <"btn-container"B> <"search-container"f>>rtip',
        buttons: [
            {
                extend: "excelHtml5",
                text: '<i class="fa-solid fa-file-excel"></i>',
                className: "btn btn-success",
                titleAttr: "Exportar a Excel"
            },
            {
                extend: "pdfHtml5",
                text: '<i class="fa-solid fa-file-pdf"></i>',
                className: "btn btn-danger",
                titleAttr: "Exportar a PDF",
                orientation: "landscape",
                pageSize: "A4"
            }
        ],
        language: {
            search: "Buscar:",
            zeroRecords: "No se encontraron resultados",
            info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
            infoEmpty: "Mostrando 0 de 0 registros",
            emptyTable: "Ningún dato disponible en esta tabla",
            paginate: {
                first: "Primero", last: "Último", next: "Siguiente", previous: "Anterior"
            }
        },
        drawCallback: function(settings) {
            const api = this.api();
            const parseNum = val => parseFloat((val + '').replace(/[\$,]/g, "")) || 0;

            const sum = idx => api.column(idx).data().reduce((a, b) => parseNum(a) + parseNum(b), 0);

            api.column(7).footer().innerHTML  = sum(7).toLocaleString("es-EC", { style: "currency", currency: "USD" });
            api.column(8).footer().innerHTML  = sum(8).toLocaleString("es-EC", { style: "currency", currency: "USD" });
            api.column(11).footer().innerHTML = sum(11).toLocaleString("es-EC", { style: "currency", currency: "USD" });
            api.column(12).footer().innerHTML = sum(12).toLocaleString("es-EC", { style: "currency", currency: "USD" });
        }
    });

    // Recargar al cambiar filtros
    $("#fecha_inicio, #fecha_fin, #sucursal, #usuario_s").change(function() {
        table.ajax.reload();
    });

    // Carga automática de fecha actual al abrir
    const today = new Date().toISOString().split('T')[0];
    $("#fecha_inicio, #fecha_fin").val(today);
});
