$(document).ready(function() {
    var table = $("#ticket_pend_2c_ar").DataTable({
        bDeferRender: true,     // Mejorar rendimiento con grandes tablas
        paging: false,          // Quita la paginación
        bLengthChange: false,   // Oculta el selector de cantidad de registros
        bFilter: true,          // Habilita el filtro de búsqueda
        ajax: {
            url: "funcion_pendiente2c_ar.php",
            type: "POST"
        },
        columns: [
            { data: "codigo" },
            { data: "loteria" },
            { data: "numero" },
            { data: "fechar" },
            { data: "fechaj" },
            { 
                data: "valor",
                render: $.fn.dataTable.render.number(',', '.', 2, '$ ')
            },
            { data: "negocio" },
            { data: "usuario" },
            { 
                data: "pagar",
                render: $.fn.dataTable.render.number(',', '.', 2, '$ ')
            }
        ],
        columnDefs: [
            { targets: "_all", className: "text-center align-middle" }
        ],
        footerCallback: function (row, data, start, end, display) {
            var api = this.api();

            var parseNumber = function (v) {
                if (typeof v === "string") {
                    // Quita símbolo $, comas, espacios, etc.
                    v = v.replace(/[^0-9.-]/g, "");
                }
                var n = parseFloat(v);
                return isNaN(n) ? 0 : n;
            };

            // Columna 8 = "pagar"
            var total = api
                .column(8)
                .data()
                .reduce(function (a, b) {
                    return parseNumber(a) + parseNumber(b);
                }, 0);

            $(api.column(8).footer()).html('$ ' + total.toFixed(2));
        },
        language: {
            processing: "Procesando...",
            zeroRecords: "No se encontraron resultados",
            emptyTable: "Ningún dato disponible en esta tabla",
            info: "Mostrando _START_ a _END_ de _TOTAL_ registros",
            infoEmpty: "Mostrando 0 de 0 registros",
            infoFiltered: "(filtrado de _MAX_ registros)",
            loadingRecords: "Por favor espere - cargando...",
            search: "Buscar:",
            paginate: {
                first: "Primero",
                last: "Último",
                next: "Siguiente",
                previous: "Anterior"
            }
        }
    });

    // Ajustar tamaño de la caja de búsqueda
    $(".dataTables_filter input").css({
        width: "250px",
        display: "inline-block",
        padding: "6px",
        "font-size": "14px"
    });

    // Redibujar la tabla cuando se actualizan los datos
    setInterval(function() {
        table.ajax.reload(null, false); // false = mantiene la página actual (aunque no haya paginación)
    }, 30000);
});
