$(document).ready(function() {
    var table = $("#ticket_3c_ar_v").DataTable({
         "bDeferRender": true,  // Mejorar rendimiento con grandes tablas
        "paging": false,       // Quita la paginación
        "bLengthChange": false, // Oculta el selector de cantidad de registros
        "bFilter": true,       // Habilita el filtro de búsqueda
        "ajax": {
            "url": "funcion_hoy3c_ar_v.php",
            "type": "POST"
        },
        "columns": [
            {"data": "codigo"},
            {"data": "loteria"},
            {"data": "numero"},
            {"data": "fechar"},
            {"data": "fechaj"},
            {"data": "valor"},            
            {"data": "negocio"},
            {"data": "usuario"},            
            {"data": "pagar"},
            {"data": "accion"}
        ],
        "language": {
            "processing": "Procesando...",
            "zeroRecords": "No se encontraron resultados",
            "emptyTable": "Ningún dato disponible en esta tabla",
            "info": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "infoEmpty": "Mostrando 0 de 0 registros",
            "infoFiltered": "(filtrado de _MAX_ registros)",
            "loadingRecords": "Por favor espere - cargando...",
            "search": "Buscar:",  
            "paginate": {
                "first": "Primero",
                "last": "Último",
                "next": "Siguiente",
                "previous": "Anterior"
            }
        }
    });

    // Ajustar tamaño de la caja de búsqueda
    $(".dataTables_filter input").css({
        "width": "250px",
        "display": "inline-block",
        "padding": "6px",
        "font-size": "14px"
    });

    // Redibujar la tabla cuando se actualizan los datos
    setInterval(function() {
        table.ajax.reload(null, false);
    }, 30000);
});