$(document).ready(function () {

    var table_2c_ar = $("#ticket_2c_ar_v").DataTable({
        bDeferRender: true,      // Mejor rendimiento
        paging: false,           // Sin paginación
        bLengthChange: false,    // Sin selector de cantidad
        bFilter: true,           // Búsqueda
        ajax: {
            url: "funcion_hoy2c_ar_v.php",
            type: "POST",
            dataSrc: "data"
        },

        columns: [
            { data: "codigo" },
            { data: "loteria" },
            { data: "numero" },
            { data: "fechar" },
            { data: "fechaj" },
            { data: "valor" },
            { data: "negocio" },
            { data: "usuario" },
            { data: "pagar" },
            { data: "accion" }
        ],
        language: {
            processing:     "Procesando...",
            zeroRecords:    "No se encontraron resultados",
            emptyTable:     "Ningún dato disponible en esta tabla",
            info:           "Mostrando _START_ a _END_ de _TOTAL_ registros",
            infoEmpty:      "Mostrando 0 de 0 registros",
            infoFiltered:   "(filtrado de _MAX_ registros)",
            loadingRecords: "Por favor espere - cargando...",
            search:         "Buscar:",
            paginate: {
                first:      "Primero",
                last:       "Último",
                next:       "Siguiente",
                previous:   "Anterior"
            }
        }
    });

    // Ajustar tamaño de la caja de búsqueda
    $(document).on('focus', '.dataTables_filter input', function () {
        $(this).css({
            width: "250px",
            display: "inline-block",
            padding: "6px",
            fontSize: "14px"
        });
    });

    // Recargar datos cada 30 segundos sin perder posición
    setInterval(function () {
        table_2c_ar.ajax.reload(null, false);
    }, 30000);

    // Cuando se abre el modal, ajustar columnas (por si se ve chueco)
    $('#ventasModalAr').on('shown.bs.modal', function () {
        table_2c_ar.columns.adjust().draw(false);
    });
});
