<?php
session_start();

// Establece el directorio raíz (puedes cambiarlo)
$rootDir = __DIR__;

// Obtener el directorio actual desde la URL o usar raíz
$currentDir = isset($_GET['dir']) ? $_GET['dir'] : '';

$currentDir = realpath($rootDir . '/' . $currentDir);

// Asegurar que el directorio está dentro del raíz para evitar accesos no autorizados
if (strpos($currentDir, realpath($rootDir)) !== 0) {
    $currentDir = realpath($rootDir);
}

// Función para sanitizar rutas
function getRelativePath($absPath, $root) {
    return ltrim(str_replace($root, '', $absPath), '/');
}

// Función para eliminar archivos
if (isset($_POST['delete'])) {
    $fileToDelete = $_POST['delete'];
    $pathToDelete = realpath($currentDir . '/' . $fileToDelete);
    if (strpos($pathToDelete, $currentDir) === 0 && file_exists($pathToDelete)) {
        if (is_dir($pathToDelete)) {
            // Eliminar directorio (recursivamente)
            function deleteDir($dirPath) {
                if (!is_dir($dirPath)) return;
                $items = scandir($dirPath);
                foreach ($items as $item) {
                    if ($item == '.' || $item == '..') continue;
                    $itemPath = $dirPath . DIRECTORY_SEPARATOR . $item;
                    if (is_dir($itemPath)) {
                        deleteDir($itemPath);
                    } else {
                        unlink($itemPath);
                    }
                }
                rmdir($dirPath);
            }
            deleteDir($pathToDelete);
        } else {
            unlink($pathToDelete);
        }
        header("Location: ?dir=" . urlencode(getRelativePath($currentDir, $rootDir)));
        exit;
    }
}

// Función para subir archivos
if (isset($_POST['upload'])) {
    if (isset($_FILES['file'])) {
        $uploadFile = $_FILES['file'];
        $targetPath = $currentDir . '/' . basename($uploadFile['name']);
        if (move_uploaded_file($uploadFile['tmp_name'], $targetPath)) {
            // Éxito
        } else {
            $error = "Error al subir el archivo.";
        }
        header("Location: ?dir=" . urlencode(getRelativePath($currentDir, $rootDir)));
        exit;
    }
}

// Función para descargar archivos
if (isset($_GET['download'])) {
    $fileToDownload = $_GET['download'];
    $filePath = realpath($currentDir . '/' . $fileToDownload);
    if (strpos($filePath, $currentDir) === 0 && file_exists($filePath)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filePath));
        readfile($filePath);
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<title>File Manager PHP</title>
<style>
body { font-family: Arial, sans-serif; margin: 20px; }
h2 { margin-top: 0; }
table { width: 100%; border-collapse: collapse; }
th, td { padding: 8px; border: 1px solid #ccc; text-align: left; }
a { text-decoration: none; color: blue; }
</style>
</head>
<body>

<h2>PHP Structure</h2>

<!-- Botón para subir archivo -->
<form action="" method="post" enctype="multipart/form-data" style="margin-bottom:20px;">
    <input type="file" name="file" required />
    <button type="submit" name="upload">Subir archivo</button>
</form>

<!-- Navegar al nivel superior -->
<?php
$parentDir = dirname($currentDir);
if (strpos($currentDir, $rootDir) === 0 && $currentDir != $rootDir) {
    echo '<a href="?dir=' . urlencode(getRelativePath($parentDir, $rootDir)) . '">🔼 Nivel superior</a><br/><br/>';
}
?>

<!-- Lista de archivos y directorios -->
<table>
<tr>
    <th>Nombre</th>
    <th>Tipo</th>
    <th>Acciones</th>
</tr>
<?php
$items = scandir($currentDir);
foreach ($items as $item) {
    if ($item == '.') continue;
    $itemPath = $currentDir . '/' . $item;
    $relPath = getRelativePath($itemPath, $rootDir);
    if (is_dir($itemPath)) {
        // Directorio
        echo '<tr>';
        echo '<td>📁 <a href="?dir=' . urlencode($relPath) . '">' . htmlspecialchars($item) . '</a></td>';
        echo '<td>Carpeta</td>';
        echo '<td></td>';
        echo '</tr>';
    } else {
        // Archivo
        echo '<tr>';
        echo '<td>📄 ' . htmlspecialchars($item) . '</td>';
        echo '<td>' . htmlspecialchars(pathinfo($item, PATHINFO_EXTENSION)) . '</td>';
        echo '<td>';
        // Descargar
        echo '<a href="?dir=' . urlencode(getRelativePath($currentDir, $rootDir)) . '&download=' . urlencode($item) . '">📥 Descargar</a> | ';
        // Eliminar
        echo '<form style="display:inline;" method="post" onsubmit="return confirm(\'¿Seguro que quieres eliminar este archivo?\');">';
        echo '<input type="hidden" name="delete" value="' . htmlspecialchars($item) . '" />';
        echo '<button type="submit" style="background:none;border:none;color:red;cursor:pointer;">🗑️ Eliminar</button>';
        echo '</form>';
        echo '</td>';
        echo '</tr>';
    }
}
?>
</table>

</body>
</html>
